/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.diffset;

import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.collection.diffset.MutableIntDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class MutableIntDiffSetsImpl
implements MutableIntDiffSets {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MutableIntDiffSetsImpl.class);
    private static final MutableIntSet NOT_INITIALIZED = IntSets.mutable.empty().asUnmodifiable();
    private final CollectionsFactory collectionsFactory;
    private final MemoryTracker memoryTracker;
    private MutableIntSet added;
    private MutableIntSet removed;

    static MutableIntDiffSetsImpl createMutableIntDiffSetsImpl(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new MutableIntDiffSetsImpl(collectionsFactory, memoryTracker);
    }

    @VisibleForTesting
    public MutableIntDiffSetsImpl(MutableIntSet added, MutableIntSet removed, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        this.added = added;
        this.removed = removed;
        this.collectionsFactory = collectionsFactory;
        this.memoryTracker = memoryTracker;
    }

    @VisibleForTesting
    public MutableIntDiffSetsImpl(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        this(NOT_INITIALIZED, NOT_INITIALIZED, collectionsFactory, memoryTracker);
    }

    @Override
    public boolean isAdded(int element) {
        return this.added.contains(element);
    }

    @Override
    public boolean isRemoved(int element) {
        return this.removed.contains(element);
    }

    @Override
    public void add(int element) {
        this.checkAddedElements();
        this.addElement(element);
    }

    @Override
    public boolean remove(int element) {
        this.checkRemovedElements();
        return this.removeElement(element);
    }

    @Override
    public int delta() {
        return this.added.size() - this.removed.size();
    }

    @Override
    public IntSet getAdded() {
        return this.added;
    }

    @Override
    public IntSet getRemoved() {
        return this.removed;
    }

    @Override
    public IntSet getRemovedFromAdded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.added.isEmpty() && this.removed.isEmpty();
    }

    private void addElement(int element) {
        if (this.removed.isEmpty() || !this.removed.remove(element)) {
            this.added.add(element);
        }
    }

    private boolean removeElement(int element) {
        if (!this.added.isEmpty() && this.added.remove(element)) {
            return true;
        }
        return this.removed.add(element);
    }

    private void checkAddedElements() {
        if (this.added == NOT_INITIALIZED) {
            this.added = this.collectionsFactory.newIntSet(this.memoryTracker);
        }
    }

    private void checkRemovedElements() {
        if (this.removed == NOT_INITIALIZED) {
            this.removed = this.collectionsFactory.newIntSet(this.memoryTracker);
        }
    }
}

