/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class MapUtil {
    private MapUtil() {
    }

    public static <K, V> Map<K, V> genericMap(Object ... objects) {
        return MapUtil.genericMap(new HashMap(), objects);
    }

    public static <K, V> Map<K, V> genericMap(Map<K, V> targetMap, Object ... objects) {
        int i = 0;
        while (i < objects.length) {
            targetMap.put(objects[i++], objects[i++]);
        }
        return targetMap;
    }

    public static Map<String, String> stringMap(String ... strings) {
        return MapUtil.genericMap(strings);
    }

    public static Map<String, String> stringMap(Map<String, String> targetMap, String ... strings) {
        return MapUtil.genericMap(targetMap, (Object[])strings);
    }

    public static Map<String, Object> map(Object ... objects) {
        return MapUtil.genericMap(objects);
    }

    public static Map<String, Object> map(Map<String, Object> targetMap, Object ... objects) {
        return MapUtil.genericMap(targetMap, objects);
    }

    public static Map<String, String> load(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.put((String)entry.getKey(), ((String)entry.getValue()).trim());
        }
        return result;
    }

    public static void store(Map<String, String> config, Path file) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            MapUtil.store(config, stream);
        }
    }

    public static void store(Map<String, String> config, OutputStream stream) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> property : config.entrySet()) {
            properties.setProperty(property.getKey(), property.getValue());
        }
        properties.store(stream, null);
    }

    public static void store(Map<String, String> config, Writer writer) throws IOException {
        Properties properties = new Properties();
        properties.putAll(config);
        properties.store(writer, null);
    }
}

