/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.error;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlException;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class BoltException
extends GqlException
implements Status.HasStatus {
    private final Status status;

    private BoltException(ErrorGqlStatusObject gql, Status status, String message) {
        super(gql, message);
        this.status = status;
    }

    private BoltException(ErrorGqlStatusObject gql, Status status, String message, Throwable cause) {
        super(gql, message, cause);
        this.status = status;
    }

    public static BoltException invalidServerState(String message, String serverState) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N06).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N10).withParam(GqlParams.StringParam.msg, message).withParam(GqlParams.StringParam.boltServerState, serverState).build()).build();
        return new BoltException(gql, (Status)Status.Request.Invalid, "Message '" + message + "' cannot be handled by session in the " + serverState + " state");
    }

    public static BoltException failedToAcquireExecutionThread() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N59).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N38).build()).build();
        return new BoltException(gql, (Status)Status.Request.NoThreadsAvailable, Status.Request.NoThreadsAvailable.code().description());
    }

    public static BoltException outOfMemory(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N59).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N36).build()).build();
        return new BoltException(gql, (Status)Status.General.OutOfMemoryError, ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
    }

    public static BoltException stackOverflow(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N59).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N37).build()).build();
        return new BoltException(gql, (Status)Status.General.StackOverFlowError, ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
    }

    public static BoltException unknownError(Throwable cause) {
        if (cause == null) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
            return new BoltException(gql, (Status)Status.General.UnknownError, Status.General.UnknownError.code().description(), cause);
        }
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N00).withParam(GqlParams.StringParam.msgTitle, cause.getClass().getSimpleName()).withParam(GqlParams.StringParam.msg, cause.getMessage() != null ? cause.getMessage() : "").withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N09).withParam(GqlParams.StringParam.boltServerState, "uncaught error").build()).build();
        return new BoltException(gql, (Status)Status.General.UnknownError, ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
    }

    public Status status() {
        return this.status;
    }
}

