/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.ProtocolVersionReducer;
import org.neo4j.bolt.negotiation.message.ModernProtocolNegotiationInitMessage;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.negotiation.util.BitMask;
import org.neo4j.bolt.negotiation.util.NegotiationEncodingUtil;
import org.neo4j.memory.HeapEstimator;

public final class ModernProtocolNegotiationInitMessageEncoder
extends MessageToByteEncoder<ModernProtocolNegotiationInitMessage> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ModernProtocolNegotiationInitMessageEncoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ModernProtocolNegotiationInitMessage msg, ByteBuf out) throws Exception {
        List<ProtocolVersion> canonicalVersions = ProtocolVersionReducer.canonicalize(msg.supportedVersions());
        out.writeInt(msg.negotiationVersion().encode());
        NegotiationEncodingUtil.writeVarInt(out, canonicalVersions.size());
        canonicalVersions.forEach(version -> out.writeInt(version.encode()));
        BitMask capabilityMask = ProtocolCapability.toBitMask(ctx.alloc(), msg.capabilities());
        try {
            NegotiationEncodingUtil.writeBitMask(out, capabilityMask);
        }
        finally {
            ReferenceCountUtil.release((Object)capabilityMask);
        }
    }
}

