/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.message;

import java.util.List;
import java.util.Objects;
import org.neo4j.bolt.negotiation.ProtocolVersion;

public record ProtocolNegotiationRequest(int magicNumber, List<ProtocolVersion> proposedVersions) {
    public static final int ENCODED_SIZE = 20;

    public ProtocolNegotiationRequest(int magicNumber, List<ProtocolVersion> proposedVersions) {
        this.magicNumber = magicNumber;
        this.proposedVersions = List.copyOf(proposedVersions);
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public List<ProtocolVersion> getProposedVersions() {
        return this.proposedVersions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolNegotiationRequest that = (ProtocolNegotiationRequest)o;
        return this.magicNumber == that.magicNumber && Objects.equals(this.proposedVersions, that.proposedVersions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.magicNumber, this.proposedVersions);
    }

    @Override
    public String toString() {
        return "ProtocolNegotiationRequest{magicNumber=0x" + Integer.toHexString(this.magicNumber) + ", proposedVersions=" + String.valueOf(this.proposedVersions) + "}";
    }
}

