/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.util.Objects;
import org.neo4j.util.Preconditions;

public final class BitMask
implements ReferenceCounted {
    private final ByteBuf encoded;
    private final int length;
    private int readerIndex;
    private int writerIndex;

    private BitMask(ByteBuf encoded, int length) {
        Objects.requireNonNull(encoded, "encoded");
        Preconditions.requireNonNegative((int)length);
        this.encoded = encoded;
        this.length = length;
    }

    public BitMask(ByteBufAllocator alloc, int length) {
        this(BitMask.allocateZeroedBuffer(alloc, length), length);
    }

    private static ByteBuf allocateZeroedBuffer(ByteBufAllocator alloc, int length) {
        int bufferLength = length / 8 + (length % 8 == 0 ? 0 : 1);
        return alloc.buffer(bufferLength).setZero(0, bufferLength);
    }

    public BitMask(byte[] encoded) {
        this(Unpooled.wrappedBuffer((byte[])encoded), encoded.length * 8);
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("Expected mask index to be within bounds 0 < x < " + this.length + " but got " + index);
        }
        int arrayIndex = index / 8;
        int bitOffset = index % 8;
        return (this.encoded.getByte(arrayIndex) & 1 << bitOffset) != 0;
    }

    public int readable() {
        return this.length - this.readerIndex;
    }

    public boolean isReadable() {
        return this.isReadable(1);
    }

    public boolean isReadable(int bits) {
        return this.readable() >= bits;
    }

    public boolean read() {
        return this.get(this.readerIndex++);
    }

    public int readN(int length) {
        if (length < 0 || length > 31) {
            throw new IllegalArgumentException("Expected mask index to be within bounds 0 < x <= 31 but got " + length);
        }
        if (length == 0) {
            return 0;
        }
        int accumulator = 0;
        for (int i = 0; i < length; ++i) {
            accumulator ^= (this.read() ? 1 : 0) << i;
        }
        return accumulator;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.length) {
            throw new IllegalArgumentException("Expected mask index to be within bounds 0 < x < " + this.length + " but got " + index);
        }
        int arrayIndex = index / 8;
        int bitOffset = index % 8;
        byte heap = this.encoded.getByte(arrayIndex);
        heap = value ? (byte)(heap | 1 << bitOffset) : (byte)(heap & ~(1 << bitOffset));
        this.encoded.setByte(arrayIndex, (int)heap);
    }

    public int writable() {
        return this.length - this.writerIndex;
    }

    public boolean isWritable() {
        return this.isWritable(1);
    }

    public boolean isWritable(int length) {
        return this.writable() >= length;
    }

    public void write(boolean value) {
        this.set(this.writerIndex++, value);
    }

    public void writeN(int value, int length) {
        for (int i = 0; i < length; ++i) {
            this.write((value >> i & 1) != 0);
        }
    }

    public int length() {
        return this.length;
    }

    public ByteBuf asReadOnlyBuffer() {
        return this.encoded.asReadOnly();
    }

    public int refCnt() {
        return this.encoded.refCnt();
    }

    public BitMask retain() {
        this.encoded.retain();
        return this;
    }

    public BitMask retain(int i) {
        this.encoded.retain(i);
        return this;
    }

    public BitMask touch() {
        this.encoded.touch();
        return this;
    }

    public BitMask touch(Object o) {
        this.encoded.touch(o);
        return this;
    }

    public boolean release() {
        ByteBuf byteBuf = this.encoded;
        if (byteBuf == null) {
            return false;
        }
        return byteBuf.release();
    }

    public boolean release(int i) {
        return this.encoded.release(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitMask)) {
            return false;
        }
        BitMask booleans = (BitMask)o;
        return this.length == booleans.length && Objects.deepEquals(this.encoded, booleans.encoded);
    }

    public int hashCode() {
        return Objects.hash(this.encoded.hashCode(), this.length);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.encoded.readerIndex(0);
        try {
            while (this.encoded.isReadable()) {
                byte b = this.encoded.readByte();
                builder.append(String.format("%8s", Integer.toBinaryString(b)).replace(' ', '0'));
            }
        }
        finally {
            this.encoded.readerIndex(0);
        }
        return builder.reverse().toString();
    }
}

