/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.ConnectionHandle;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.DefaultMetadataHandler;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.reader.DateReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeZoneIdReader;
import org.neo4j.bolt.protocol.io.reader.DurationReader;
import org.neo4j.bolt.protocol.io.reader.LocalDateTimeReader;
import org.neo4j.bolt.protocol.io.reader.LocalTimeReader;
import org.neo4j.bolt.protocol.io.reader.Point2dReader;
import org.neo4j.bolt.protocol.io.reader.Point3dReader;
import org.neo4j.bolt.protocol.io.reader.TimeReader;
import org.neo4j.bolt.protocol.io.reader.VectorReader;
import org.neo4j.bolt.protocol.io.writer.DefaultStructWriter;
import org.neo4j.bolt.protocol.v40.BoltProtocolV40;
import org.neo4j.bolt.protocol.v41.BoltProtocolV41;
import org.neo4j.bolt.protocol.v42.BoltProtocolV42;
import org.neo4j.bolt.protocol.v43.BoltProtocolV43;
import org.neo4j.bolt.protocol.v44.BoltProtocolV44;
import org.neo4j.bolt.protocol.v50.BoltProtocolV50;
import org.neo4j.bolt.protocol.v51.BoltProtocolV51;
import org.neo4j.bolt.protocol.v52.BoltProtocolV52;
import org.neo4j.bolt.protocol.v53.BoltProtocolV53;
import org.neo4j.bolt.protocol.v54.BoltProtocolV54;
import org.neo4j.bolt.protocol.v56.BoltProtocolV56;
import org.neo4j.bolt.protocol.v57.BoltProtocolV57;
import org.neo4j.bolt.protocol.v58.BoltProtocolV58;
import org.neo4j.bolt.protocol.v60.BoltProtocolV60;
import org.neo4j.packstream.signal.FrameSignal;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.values.storable.Value;

public interface BoltProtocol {
    public static List<BoltProtocol> installed() {
        return List.of(BoltProtocolV40.getInstance(), BoltProtocolV41.getInstance(), BoltProtocolV42.getInstance(), BoltProtocolV43.getInstance(), BoltProtocolV44.getInstance(), BoltProtocolV50.getInstance(), BoltProtocolV51.getInstance(), BoltProtocolV52.getInstance(), BoltProtocolV53.getInstance(), BoltProtocolV54.getInstance(), BoltProtocolV56.getInstance(), BoltProtocolV57.getInstance(), BoltProtocolV58.getInstance(), BoltProtocolV60.getInstance());
    }

    public static String latestVersionInstalled() {
        return BoltProtocol.installed().stream().map(BoltProtocol::version).max(ProtocolVersion::compareTo).map(ProtocolVersion::toString).orElseThrow();
    }

    public static List<BoltProtocol> available() {
        return BoltProtocol.installed().stream().filter(it -> !it.preview()).toList();
    }

    public ProtocolVersion version();

    default public boolean preview() {
        return false;
    }

    default public Set<Feature> features() {
        return Set.of(Feature.UTC_DATETIME);
    }

    default public Predicate<FrameSignal> frameSignalFilter() {
        return signal -> false;
    }

    public StateMachineConfiguration stateMachine();

    public StructRegistry<Connection, RequestMessage> requestMessageRegistry();

    public StructRegistry<Connection, ResponseMessage> responseMessageRegistry();

    default public void registerStructReaders(StructRegistry.Builder<Connection, Value> builder) {
        builder.register(DateReader.getInstance()).register(DurationReader.getInstance()).register(LocalDateTimeReader.getInstance()).register(LocalTimeReader.getInstance()).register(Point2dReader.getInstance()).register(Point3dReader.getInstance()).register(TimeReader.getInstance()).register(DateTimeReader.getInstance()).register(DateTimeZoneIdReader.getInstance()).register(VectorReader.getInstance());
    }

    default public void registerStructWriters(WriterPipeline pipeline) {
        pipeline.addLast(DefaultStructWriter.getInstance());
    }

    default public MetadataHandler metadataHandler() {
        return DefaultMetadataHandler.getInstance();
    }

    default public void onConnectionNegotiated(ConnectionHandle connection) {
    }
}

