/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.config;

import io.netty.handler.ssl.SslContext;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.neo4j.bolt.protocol.common.connector.config.AbstractConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.config.NettyConnectorConfiguration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.ssl.config.ScopedSslPolicyProvider;

public abstract class AbstractNettyConnectorConfiguration
extends AbstractConnectorConfiguration
implements NettyConnectorConfiguration {
    private final boolean enableMergeCumulator;
    private final ScopedSslPolicyProvider sslPolicyProvider;
    private volatile SslPolicy lastReceivedPolicy;
    private volatile SslContext currentSslContext;

    public AbstractNettyConnectorConfiguration(AbstractFactory<?> builder) {
        super(builder);
        this.enableMergeCumulator = builder.enableMergeCumulator;
        this.sslPolicyProvider = builder.sslPolicyProvider;
    }

    @Override
    public boolean enableMergeCumulator() {
        return this.enableMergeCumulator;
    }

    @Override
    public SslContext sslContext() {
        boolean hasPolicy;
        SslPolicy policy = this.sslPolicyProvider.getPolicy();
        SslContext sslContext = this.currentSslContext;
        boolean hasPolicyChanged = policy != this.lastReceivedPolicy;
        boolean hasContext = sslContext != null;
        boolean bl = hasPolicy = policy != null;
        if (!(hasPolicyChanged || hasPolicy && !hasContext)) {
            return sslContext;
        }
        if (policy == null) {
            this.lastReceivedPolicy = null;
            return null;
        }
        try {
            sslContext = policy.nettyServerContext();
            this.lastReceivedPolicy = policy;
            return sslContext;
        }
        catch (SSLException ex) {
            throw new IllegalStateException("Failed to load SSL policy for connector", ex);
        }
    }

    public static abstract class AbstractFactory<SELF extends AbstractFactory<SELF>>
    extends AbstractConnectorConfiguration.AbstractFactory<SELF>
    implements NettyConnectorConfiguration.Factory<SELF> {
        private boolean enableMergeCumulator = true;
        private ScopedSslPolicyProvider sslPolicyProvider = ScopedSslPolicyProvider.getNullInstance();

        @Override
        public SELF fromConfig(Config config) {
            super.fromConfig(config);
            this.enableMergeCumulator = (Boolean)config.get(BoltConnectorInternalSettings.netty_message_merge_cumulator);
            return (SELF)this;
        }

        @Override
        public SELF enableMergeCumulator(boolean value) {
            this.enableMergeCumulator = value;
            return (SELF)this;
        }

        @Override
        public SELF sslPolicyProvider(ScopedSslPolicyProvider policyProvider) {
            Objects.requireNonNull(policyProvider, "SslPolicyProvider cannot be null");
            this.sslPolicyProvider = policyProvider;
            return (SELF)this;
        }
    }
}

