/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.time.Duration;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.handler.AuthenticationProtocolLimiterHandler;
import org.neo4j.bolt.protocol.common.handler.AuthenticationTimeoutHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class AuthenticationSecurityConnectionListener
implements ConnectionListener {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AuthenticationSecurityConnectionListener.class);
    private final Connection connection;
    private final Duration timeout;
    private final InternalLog log;
    private volatile AuthenticationTimeoutHandler timeoutHandler;
    private volatile AuthenticationProtocolLimiterHandler protocolLimiterHandler;

    public AuthenticationSecurityConnectionListener(Connection connection, Duration timeout, InternalLogProvider logging) {
        this.connection = connection;
        this.timeout = timeout;
        this.log = logging.getLog(AuthenticationSecurityConnectionListener.class);
    }

    @Override
    public void onListenerRemoved() {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    @Override
    public void onNetworkPipelineInitialized(ChannelPipeline pipeline) {
        this.log.debug("[%s] Installing authentication timeout handler", new Object[]{this.connection.id()});
        this.connection.memoryTracker().allocateHeap(AuthenticationTimeoutHandler.SHALLOW_SIZE);
        this.timeoutHandler = new AuthenticationTimeoutHandler(this.timeout);
        pipeline.addLast(new ChannelHandler[]{this.timeoutHandler});
    }

    @Override
    public void onProtocolSelected(BoltProtocol protocol) {
        this.installStructureLimitHandler();
    }

    @Override
    public void onRequestReceived(RequestMessage message) {
        if (this.timeoutHandler != null) {
            this.log.debug("[%s] Received request during authentication phase", new Object[]{this.connection.id()});
            this.timeoutHandler.setRequestReceived(true);
        }
    }

    @Override
    public void onLogon(LoginContext ctx) {
        this.log.debug("[%s] Removing authentication timeout handler", new Object[]{this.connection.id()});
        if (this.timeoutHandler != null) {
            AuthenticationTimeoutHandler timeoutHandler = this.timeoutHandler;
            AuthenticationProtocolLimiterHandler protocolLimiterHandler = this.protocolLimiterHandler;
            this.connection.modifyPipeline(pipeline -> {
                pipeline.remove((ChannelHandler)timeoutHandler);
                if (protocolLimiterHandler != null) {
                    pipeline.remove((ChannelHandler)protocolLimiterHandler);
                }
            });
            this.timeoutHandler = null;
            this.protocolLimiterHandler = null;
        }
    }

    @Override
    public void onLogoff() {
        AuthenticationTimeoutHandler timeoutHandler;
        this.log.debug("[%s] Re-adding authentication timeout handler", new Object[]{this.connection.id()});
        this.connection.memoryTracker().allocateHeap(AuthenticationTimeoutHandler.SHALLOW_SIZE);
        this.timeoutHandler = timeoutHandler = new AuthenticationTimeoutHandler(this.timeout);
        this.connection.modifyPipeline(pipeline -> pipeline.addBefore("housekeeper", "authenticationTimeoutHandler", (ChannelHandler)timeoutHandler));
        this.installStructureLimitHandler();
    }

    private void installStructureLimitHandler() {
        AuthenticationProtocolLimiterHandler protocolLimiterHandler;
        Object config = this.connection.connector().configuration();
        int structureElementLimit = config.maxAuthenticationStructureElements();
        int structureDepthLimit = config.maxAuthenticationStructureDepth();
        if (structureElementLimit == 0 && structureDepthLimit == 0) {
            this.log.debug("[%s] Authentication structure limit is disabled", new Object[]{this.connection.id()});
            return;
        }
        this.log.debug("[%s] Imposing authentication structure limits of %d elements with a maximum depth of %d", new Object[]{this.connection.id(), structureElementLimit, structureDepthLimit});
        this.connection.memoryTracker().allocateHeap(AuthenticationProtocolLimiterHandler.SHALLOW_SIZE);
        this.protocolLimiterHandler = protocolLimiterHandler = new AuthenticationProtocolLimiterHandler(structureElementLimit, structureDepthLimit);
        this.connection.modifyPipeline(pipeline -> pipeline.addAfter("chunkFrameDecoder", "protocolLimiterHandler", (ChannelHandler)protocolLimiterHandler));
    }
}

