/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.transport;

import io.netty.channel.Channel;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.annotations.service.Service;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorOption;
import org.neo4j.bolt.protocol.common.connector.transport.EpollConnectorTransport;
import org.neo4j.bolt.protocol.common.connector.transport.KqueueConnectorTransport;
import org.neo4j.bolt.protocol.common.connector.transport.LocalConnectorTransport;
import org.neo4j.bolt.protocol.common.connector.transport.NioConnectorTransport;
import org.neo4j.service.PrioritizedService;
import org.neo4j.service.Services;

@Service
public sealed interface ConnectorTransport
extends PrioritizedService
permits EpollConnectorTransport, KqueueConnectorTransport, NioConnectorTransport, LocalConnectorTransport {
    public static Stream<ConnectorTransport> listAvailable() {
        return Services.loadAll(ConnectorTransport.class).stream();
    }

    public static Optional<ConnectorTransport> selectOptimal(Predicate<ConnectorTransport> filter) {
        return ConnectorTransport.listAvailable().filter(filter).filter(ConnectorTransport::isAvailable).min(Comparator.comparingInt(ConnectorTransport::getPriority));
    }

    public static Optional<ConnectorTransport> selectOptimal() {
        return ConnectorTransport.selectOptimal(transport -> true);
    }

    public String getName();

    default public int getPriority() {
        return 0;
    }

    public boolean isAvailable();

    public boolean isNative();

    default public boolean supportsOption(ConnectorOption<?> option) {
        return false;
    }

    public IoHandlerFactory createIoHandlerFactory();

    public Class<? extends Channel> socketChannelType();

    public Class<? extends ServerChannel> serverSocketChannelType();

    default public Class<? extends DomainSocketChannel> domainSocketChannelType() {
        return null;
    }

    default public Class<? extends ServerDomainSocketChannel> serverDomainSocketChannelType() {
        return null;
    }
}

