/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.authentication;

import java.util.Collections;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.util.AuthenticationMetadataUtils;
import org.neo4j.bolt.protocol.common.message.request.authentication.LogonMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;

public final class DefaultLogonMessageDecoder
implements MessageDecoder<LogonMessage> {
    private static final DefaultLogonMessageDecoder INSTANCE = new DefaultLogonMessageDecoder();

    private DefaultLogonMessageDecoder() {
    }

    public static DefaultLogonMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 106;
    }

    @Override
    public LogonMessage read(Connection connection, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        PackstreamConditions.requireLength(header, 1);
        PackstreamValueReader<Connection> valueReader = connection.valueReader(buffer);
        Map<String, Object> meta = AuthenticationMetadataUtils.convertExtraMap(valueReader, buffer.raw().readableBytes());
        Map<String, Object> authToken = AuthenticationMetadataUtils.extractAuthToken(Collections.emptyList(), meta);
        return new LogonMessage(authToken);
    }
}

