/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.connection;

import java.util.List;
import java.util.Optional;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.AbstractTransactionInitiatingMessageDecoder;
import org.neo4j.bolt.protocol.common.message.request.connection.RouteMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class LegacyRouteMessageDecoder
implements MessageDecoder<RouteMessage> {
    private static final LegacyRouteMessageDecoder INSTANCE = new LegacyRouteMessageDecoder();

    private LegacyRouteMessageDecoder() {
    }

    public static LegacyRouteMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 102;
    }

    @Override
    public RouteMessage read(Connection connection, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        PackstreamConditions.requireLength(header, 3);
        PackstreamValueReader<Connection> valueReader = connection.valueReader(buffer);
        MapValue routingContext = valueReader.readMap();
        List<String> bookmarkList = List.of();
        if (buffer.peekType() != Type.NONE) {
            bookmarkList = AbstractTransactionInitiatingMessageDecoder.convertBookmarks(valueReader.readList());
        }
        String databaseName = Optional.of(valueReader.readValue()).filter(any -> any != Values.NO_VALUE && any instanceof TextValue).map(any -> ((TextValue)any).stringValue()).orElse(null);
        return new RouteMessage(routingContext, bookmarkList, databaseName, null);
    }
}

