/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.transaction;

import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.AbstractTransactionInitiatingMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.util.TransactionInitiatingMetadataParser;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.transaction.BeginMessage;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.packstream.util.PackstreamConversions;
import org.neo4j.values.virtual.MapValue;

public class DefaultBeginMessageDecoder
extends AbstractTransactionInitiatingMessageDecoder<BeginMessage> {
    private static final DefaultBeginMessageDecoder INSTANCE = new DefaultBeginMessageDecoder();

    protected DefaultBeginMessageDecoder() {
    }

    public static DefaultBeginMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 17;
    }

    @Override
    public BeginMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        MapValue metadata;
        PackstreamConditions.requireLength(header, 1);
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        try {
            metadata = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw IllegalStructArgumentException.protocolError("metadata", ex);
        }
        List<String> bookmarks = this.readBookmarks(metadata);
        try {
            Duration timeout = this.readTimeout(metadata);
            AccessMode accessMode = this.readAccessMode(metadata);
            Map<String, Object> txMetadata = this.readMetadata(metadata);
            String databaseName = TransactionInitiatingMetadataParser.readDatabaseName(metadata);
            String impersonatedUser = this.readImpersonatedUser(metadata);
            TransactionType type = this.readType(metadata);
            NotificationsConfig notificationsConfig = this.readNotificationsConfig(metadata);
            return new BeginMessage(bookmarks, timeout, accessMode, txMetadata, databaseName, impersonatedUser, type, notificationsConfig);
        }
        catch (PackstreamReaderException ex) {
            throw IllegalStructArgumentException.protocolError("metadata", ex);
        }
    }

    protected TransactionType readType(MapValue meta) throws PackstreamReaderException {
        String transactionType = PackstreamConversions.asNullableStringValue("tx_type", meta.get("tx_type"));
        if (transactionType == null) {
            return TransactionType.EXPLICIT;
        }
        try {
            return TransactionType.valueOf(transactionType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            return TransactionType.EXPLICIT;
        }
    }
}

