/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.struct.StructHeader;

public class UnexpectedStructException
extends PackstreamReaderException {
    private final short tag;
    private final long length;

    private UnexpectedStructException(ErrorGqlStatusObject gqlStatusObject, short tag, long length) {
        super(gqlStatusObject, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)String.format("Unexpected struct tag: 0x%02X", tag)), String.format("Unexpected struct tag: 0x%02X", tag));
        this.tag = tag;
        this.length = length;
    }

    private UnexpectedStructException(ErrorGqlStatusObject gqlStatusObject, StructHeader header) {
        this(gqlStatusObject, header.tag(), header.length());
    }

    public static UnexpectedStructException unexpectedStruct(StructHeader header) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N97).withParam(GqlParams.StringParam.value, String.format("0x%02X", header.tag())).build()).build();
        return new UnexpectedStructException(gql, header);
    }

    public short getTag() {
        return this.tag;
    }

    public long getLength() {
        return this.length;
    }
}

