/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.io.value;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.reader.UnexpectedTypeException;
import org.neo4j.packstream.error.reader.UnexpectedTypeMarkerException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.function.Reader;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public class PackstreamValueReader<CTX> {
    private final CTX ctx;
    private final PackstreamBuf buf;
    private final StructRegistry<CTX, Value> structRegistry;

    public PackstreamValueReader(CTX ctx, PackstreamBuf buf, StructRegistry<CTX, Value> structRegistry) {
        this.ctx = ctx;
        this.buf = buf;
        this.structRegistry = structRegistry;
    }

    public AnyValue readValue() throws PackstreamReaderException {
        return this.doReadValue(this.buf.peekType());
    }

    private AnyValue doReadValue(Type type) throws PackstreamReaderException {
        return switch (type) {
            case Type.STRUCT -> this.readStruct();
            case Type.LIST -> this.readList();
            case Type.MAP -> this.readMap();
            default -> this.doReadPrimitiveValue(type, -1L);
        };
    }

    public AnyValue readPrimitiveValue(long limit) throws PackstreamReaderException {
        return this.doReadPrimitiveValue(this.buf.peekType(), limit);
    }

    private AnyValue doReadPrimitiveValue(Type type, long limit) throws PackstreamReaderException {
        return switch (type) {
            case Type.NONE -> this.readNull();
            case Type.BYTES -> this.readByteArray(limit);
            case Type.BOOLEAN -> this.readBoolean();
            case Type.FLOAT -> this.readDouble();
            case Type.INT -> this.readLong();
            case Type.LIST -> this.readPrimitiveList(limit);
            case Type.MAP -> this.readPrimitiveMap(limit);
            case Type.STRING -> this.readText(limit);
            default -> throw UnexpectedTypeException.wrongType(String.valueOf(limit), List.of("NONE", "BYTES", "BOOLEAN", "FLOAT", "INT", "LIST", "MAP", "STRING"), type);
        };
    }

    public NoValue readNull() throws UnexpectedTypeMarkerException {
        this.buf.readNull();
        return NoValue.NO_VALUE;
    }

    public BooleanValue readBoolean() throws UnexpectedTypeException {
        return Values.booleanValue((boolean)this.buf.readBoolean());
    }

    public LongValue readLong() throws UnexpectedTypeException {
        return Values.longValue((long)this.buf.readInt());
    }

    public DoubleValue readDouble() throws UnexpectedTypeMarkerException {
        return Values.doubleValue((double)this.buf.readFloat64());
    }

    public ByteArray readByteArray() throws PackstreamReaderException {
        return this.readByteArray(-1L);
    }

    public ByteArray readByteArray(long limit) throws PackstreamReaderException {
        ByteBuf payload = this.buf.readBytes(limit);
        byte[] heap = new byte[payload.readableBytes()];
        payload.readBytes(heap);
        return Values.byteArray((byte[])heap);
    }

    public TextValue readText(long limit) throws PackstreamReaderException {
        return Values.stringValue((String)this.buf.readString(limit));
    }

    public TextValue readText() throws PackstreamReaderException {
        return this.readText(-1L);
    }

    public ListValue readList() throws PackstreamReaderException {
        return VirtualValues.fromList(this.buf.readList(buf -> this.readValue()));
    }

    public ListValue readPrimitiveList(long limit) throws PackstreamReaderException {
        return VirtualValues.fromList(this.buf.readList(limit, buf -> this.readPrimitiveValue(limit)));
    }

    public MapValue readMap() throws PackstreamReaderException {
        return this.doReadMap(-1L, buf -> this.readValue());
    }

    public MapValue readPrimitiveMap(long limit) throws PackstreamReaderException {
        return this.doReadMap(limit, buf -> this.readPrimitiveValue(limit));
    }

    private MapValue doReadMap(long limit, Reader<AnyValue> reader) throws PackstreamReaderException {
        Map<String, AnyValue> map = this.buf.readMap(limit, reader);
        if (map.isEmpty()) {
            return MapValue.EMPTY;
        }
        MapValueBuilder builder = new MapValueBuilder(map.size());
        map.forEach((arg_0, arg_1) -> ((MapValueBuilder)builder).add(arg_0, arg_1));
        return builder.build();
    }

    public Value readStruct() throws PackstreamReaderException {
        return this.buf.readStruct(this.ctx, this.structRegistry);
    }
}

