/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.internal.helpers.collection.ArrayIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.ReverseArrayIterator;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;

public final class PathImpl
implements Path,
Measurable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PathImpl.class);
    private final Node start;
    private final Relationship[] path;
    private final Node end;

    private static String relToString(Relationship rel) {
        return String.valueOf(rel.getStartNode()) + "--" + String.valueOf(rel.getType()) + "-->" + String.valueOf(rel.getEndNode());
    }

    private PathImpl(Builder left, Builder right) {
        int i;
        Node endNode = null;
        this.path = new Relationship[left.size + (right == null ? 0 : right.size)];
        if (right != null) {
            int total = i + right.size;
            for (i = left.size; i < total; ++i) {
                this.path[i] = right.relationship;
                right = right.previous;
            }
            assert (right.relationship == null) : "right Path.Builder size error";
            endNode = right.start;
        }
        for (i = left.size - 1; i >= 0; --i) {
            this.path[i] = left.relationship;
            left = left.previous;
        }
        assert (left.relationship == null) : "left Path.Builder size error";
        this.start = left.start;
        this.end = endNode;
    }

    public static Path singular(Node start) {
        return new Builder(start).build();
    }

    public Node startNode() {
        return this.start;
    }

    public Node endNode() {
        if (this.end != null) {
            return this.end;
        }
        Node stepNode = null;
        Iterator<Node> iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            Node node;
            stepNode = node = iterator.next();
        }
        return stepNode;
    }

    public Relationship lastRelationship() {
        return this.path != null && this.path.length > 0 ? this.path[this.path.length - 1] : null;
    }

    public Iterable<Node> nodes() {
        return this.nodeIterator(this.start, this.relationships());
    }

    public Iterable<Node> reverseNodes() {
        return this.nodeIterator(this.endNode(), this.reverseRelationships());
    }

    private Iterable<Node> nodeIterator(final Node start, final Iterable<Relationship> relationships) {
        return () -> new Iterator<Node>(){
            Node current;
            int index;
            Iterator<Relationship> relationshipIterator;
            {
                this.current = start;
                this.relationshipIterator = relationships.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.index <= PathImpl.this.path.length;
            }

            @Override
            public Node next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Node next = null;
                if (this.index < PathImpl.this.path.length) {
                    if (!this.relationshipIterator.hasNext()) {
                        throw new IllegalStateException(String.format("Number of relationships: %d does not match with path length: %d.", this.index, PathImpl.this.path.length));
                    }
                    next = this.relationshipIterator.next().getOtherNode(this.current);
                }
                ++this.index;
                try {
                    Node node = this.current;
                    return node;
                }
                finally {
                    this.current = next;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<Relationship> relationships() {
        return () -> new ArrayIterator((Object[])this.path);
    }

    public Iterable<Relationship> reverseRelationships() {
        return () -> new ReverseArrayIterator((Object[])this.path);
    }

    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            Iterator<? extends Entity> current;
            Iterator<? extends Entity> next;
            {
                this.current = PathImpl.this.nodes().iterator();
                this.next = PathImpl.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            @Override
            public Entity next() {
                try {
                    Entity entity = this.current.next();
                    return entity;
                }
                finally {
                    Iterator<? extends Entity> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    public int length() {
        return this.path.length;
    }

    public int hashCode() {
        if (this.path.length == 0) {
            return this.start.hashCode();
        }
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            return this.start.equals((Object)other.startNode()) && Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
        }
        return false;
    }

    public long estimatedHeapUsage() {
        long estimate = SHALLOW_SIZE + HeapEstimator.shallowSizeOfObjectArray((int)this.path.length);
        int pathLength = this.path.length;
        return estimate += (long)pathLength * RelationshipEntity.SHALLOW_SIZE;
    }

    public String toString() {
        return Paths.defaultPathToString((Path)this);
    }

    public static final class Builder {
        private final Builder previous;
        private final Node start;
        private final Relationship relationship;
        private final int size;

        public Builder(Node start) {
            if (start == null) {
                throw new NullPointerException();
            }
            this.start = start;
            this.previous = null;
            this.relationship = null;
            this.size = 0;
        }

        private Builder(Builder prev, Relationship rel) {
            this.start = prev.start;
            this.previous = prev;
            this.relationship = rel;
            this.size = prev.size + 1;
        }

        public Node getStartNode() {
            return this.start;
        }

        public Path build() {
            return new PathImpl(this, null);
        }

        public Builder push(Relationship relationship) {
            if (relationship == null) {
                throw new NullPointerException();
            }
            return new Builder(this, relationship);
        }

        public PathImpl build(Builder other) {
            return new PathImpl(this, other);
        }

        public String toString() {
            if (this.previous == null) {
                return this.start.toString();
            }
            return PathImpl.relToString(this.relationship) + ":" + String.valueOf(this.previous);
        }
    }
}

