/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Closeable;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b\u0001B\n\u0015\u0001}A\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003=\u0001\u0011\u0005Q\tC\u0003=\u0001\u0011\u0005\u0001\nC\u0004O\u0001\t\u0007I\u0011A(\t\ru\u0003\u0001\u0015!\u0003Q\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007\"\u00023\u0001\t\u0003)\u0007\"B5\u0001\t\u0003Q\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0002=\u0001\t\u0003I\b\"B?\u0001\t\u0003q\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u0019\t\u0019\u0003\u0001C\u0001}\nAAJR+DC\u000eDWM\u0003\u0002\u0016-\u0005)1-Y2iK*\u0011q\u0003G\u0001\tS:$XM\u001d8bY*\u0011\u0011DG\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005ma\u0012!\u00028f_RR'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007\u00012\u0004i\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\fAbY1dQ\u00164\u0015m\u0019;pef\u0004\"!\u000b\u0016\u000e\u0003QI!a\u000b\u000b\u0003)\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f\r\u0006\u001cGo\u001c:z\u0003-Ig.\u001b;jC2\u001c\u0016N_3\u0011\u0005%r\u0013BA\u0018\u0015\u0005%\u0019\u0015m\u00195f'&TX-\u0001\u0004ue\u0006\u001cWM\u001d\t\u0004SI\"\u0014BA\u001a\u0015\u0005-\u0019\u0015m\u00195f)J\f7-\u001a:\u0011\u0005U2D\u0002\u0001\u0003\u0006o\u0001\u0011\r\u0001\u000f\u0002\u0002\u0017F\u0011\u0011(\t\t\u0003EiJ!aO\u0012\u0003\u000f9{G\u000f[5oO\u00061A(\u001b8jiz\"BA\u0010\"D\tB!\u0011\u0006\u0001\u001b@!\t)\u0004\tB\u0003B\u0001\t\u0007\u0001HA\u0001W\u0011\u00159C\u00011\u0001)\u0011\u0015aC\u00011\u0001.\u0011\u0015\u0001D\u00011\u00012)\rqdi\u0012\u0005\u0006O\u0015\u0001\r\u0001\u000b\u0005\u0006Y\u0015\u0001\r!\f\u000b\u0004}%S\u0005\"B\u0014\u0007\u0001\u0004A\u0003\"\u0002\u0017\u0007\u0001\u0004Y\u0005C\u0001\u0012M\u0013\ti5EA\u0002J]R\fqB]3n_Z\fG\u000eT5ti\u0016tWM]\u000b\u0002!B!\u0011k\u0017\u001b@\u001b\u0005\u0011&BA\u000bT\u0015\t!V+\u0001\u0005dC\u001a4W-\u001b8f\u0015\t1v+\u0001\u0005cK:l\u0017M\\3t\u0015\tA\u0016,\u0001\u0004hSRDWO\u0019\u0006\u00025\u0006\u00191m\\7\n\u0005q\u0013&a\u0004*f[>4\u0018\r\u001c'jgR,g.\u001a:\u0002!I,Wn\u001c<bY2K7\u000f^3oKJ\u0004\u0013!B5o]\u0016\u0014X#\u00011\u0011\tE\u000bGgP\u0005\u0003EJ\u0013QaQ1dQ\u0016\fa!\u001b8oKJ\u0004\u0013!B2m_N,G#\u00014\u0011\u0005\t:\u0017B\u00015$\u0005\u0011)f.\u001b;\u0002\u001f\r|W\u000e];uK&3\u0017IY:f]R$2aP6n\u0011\u0015aG\u00021\u00015\u0003\rYW-\u001f\u0005\u0007]2!\t\u0019A8\u0002\u0003\u0019\u00042A\t9@\u0013\t\t8E\u0001\u0005=Eft\u0017-\\3?\u0003\r9W\r\u001e\u000b\u0003i^\u00042AI;@\u0013\t18E\u0001\u0004PaRLwN\u001c\u0005\u0006Y6\u0001\r\u0001N\u0001\u0004aV$Hc\u00014{w\")AN\u0004a\u0001i!)AP\u0004a\u0001\u007f\u0005)a/\u00197vK\u0006iQm\u001d;j[\u0006$X\rZ*ju\u0016$\u0012a \t\u0004E\u0005\u0005\u0011bAA\u0002G\t!Aj\u001c8h\u0003\u0015\t7/T1q)\t\tI\u0001\u0005\u0004\u0002\f\u0005eAgP\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005M\u0011QC\u0001\u0005kRLGN\u0003\u0002\u0002\u0018\u0005!!.\u0019<b\u0013\u0011\tY\"!\u0004\u0003\u001b\r{gnY;se\u0016tG/T1q\u0003)IgN^1mS\u0012\fG/\u001a\u000b\u0004M\u0006\u0005\u0002\"\u00027\u0012\u0001\u0004!\u0014!B2mK\u0006\u0014\b")
public class LFUCache<K, V> {
    private final CacheTracer<K> tracer;
    private final RemovalListener<K, V> removalListener;
    private final Cache<K, V> inner;

    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    private Cache<K, V> inner() {
        return this.inner;
    }

    public void close() {
        Cache<K, V> cache = this.inner();
        if (cache instanceof Closeable) {
            Cache<K, V> cache2 = cache;
            ((Closeable)cache2).close();
            return;
        }
    }

    public V computeIfAbsent(K key, Function0<V> f) {
        BooleanRef hit = BooleanRef.create((boolean)true);
        Object result = this.inner().get(key, x$1 -> {
            hit$1.elem = false;
            return f.apply();
        });
        if (hit.elem) {
            this.tracer.cacheHit(key, "");
        } else {
            this.tracer.cacheMiss(key, "");
        }
        return (V)result;
    }

    public Option<V> get(K key) {
        Option res = Option$.MODULE$.apply(this.inner().getIfPresent(key));
        if (res.isEmpty()) {
            this.tracer.cacheMiss(key, "");
        } else {
            this.tracer.cacheHit(key, "");
        }
        return res;
    }

    public void put(K key, V value) {
        this.inner().put(key, value);
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.inner().asMap();
    }

    public void invalidate(K key) {
        this.inner().invalidate(key);
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer.cacheFlush(priorSize);
        return priorSize;
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, CacheSize initialSize, CacheTracer<K> tracer) {
        this.tracer = tracer;
        this.removalListener = (key, value, cause) -> $this.tracer.discard(key, "");
        this.inner = cacheFactory.createCache(initialSize, this.removalListener());
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, CacheSize initialSize) {
        this(cacheFactory, initialSize, new CacheTracer<K>(){

            public void cacheHit(K key, String metaData) {
                CacheTracer.cacheHit$(this, key, metaData);
            }

            public void cacheMiss(K key, String metaData) {
                CacheTracer.cacheMiss$(this, key, metaData);
            }

            public void compute(K key, long codeGenSize, String metaData) {
                CacheTracer.compute$(this, key, codeGenSize, metaData);
            }

            public void discard(K key, String metaData) {
                CacheTracer.discard$(this, key, metaData);
            }

            public void computeWithExpressionCodeGen(K key, long codeGenSize, String metaData) {
                CacheTracer.computeWithExpressionCodeGen$(this, key, codeGenSize, metaData);
            }

            public void cacheStale(K key, int secondsSinceCompute, String metaData, Option<String> maybeReason) {
                CacheTracer.cacheStale$(this, key, secondsSinceCompute, metaData, maybeReason);
            }

            public void cacheFlush(long sizeOfCacheBeforeFlush) {
                CacheTracer.cacheFlush$(this, sizeOfCacheBeforeFlush);
            }

            public void awaitOngoingComputation(K key, String metaData) {
                CacheTracer.awaitOngoingComputation$(this, key, metaData);
            }
            {
                CacheTracer.$init$(this);
            }
        });
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, int initialSize) {
        this(cacheFactory, new CacheSize.Static(initialSize), new CacheTracer<K>(){

            public void cacheHit(K key, String metaData) {
                CacheTracer.cacheHit$(this, key, metaData);
            }

            public void cacheMiss(K key, String metaData) {
                CacheTracer.cacheMiss$(this, key, metaData);
            }

            public void compute(K key, long codeGenSize, String metaData) {
                CacheTracer.compute$(this, key, codeGenSize, metaData);
            }

            public void discard(K key, String metaData) {
                CacheTracer.discard$(this, key, metaData);
            }

            public void computeWithExpressionCodeGen(K key, long codeGenSize, String metaData) {
                CacheTracer.computeWithExpressionCodeGen$(this, key, codeGenSize, metaData);
            }

            public void cacheStale(K key, int secondsSinceCompute, String metaData, Option<String> maybeReason) {
                CacheTracer.cacheStale$(this, key, secondsSinceCompute, metaData, maybeReason);
            }

            public void cacheFlush(long sizeOfCacheBeforeFlush) {
                CacheTracer.cacheFlush$(this, sizeOfCacheBeforeFlush);
            }

            public void awaitOngoingComputation(K key, String metaData) {
                CacheTracer.awaitOngoingComputation$(this, key, metaData);
            }
            {
                CacheTracer.$init$(this);
            }
        });
    }
}

