/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.dbms.archive.DumpGzipFormatV1;
import org.neo4j.dbms.archive.DumpZstdFormatV1;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupFormatSelector;
import org.neo4j.function.ThrowingSupplier;

public class DumpFormatSelector {
    public static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException {
        PushbackInputStream input = new PushbackInputStream((InputStream)streamSupplier.get(), 4);
        byte[] bytes = input.readNBytes(4);
        CompressionFormat format = DumpFormatSelector.selectDumpFormat(bytes);
        if (format != null) {
            return format.decompress(input);
        }
        input.unread(bytes);
        return DumpFormatSelector.legacyDecompress(streamSupplier, input);
    }

    public static InputStream decompressWithBackupSupport(ThrowingSupplier<InputStream, IOException> streamSupplier, Consumer<BackupDescription> backupDescriptionConsumer) throws IOException {
        PushbackInputStream input = new PushbackInputStream((InputStream)streamSupplier.get(), 4);
        byte[] bytes = input.readNBytes(4);
        String magic = new String(bytes);
        Optional<BackupCompressionFormat> backupFormat = BackupFormatSelector.selectFormat(magic);
        if (backupFormat.isPresent()) {
            BackupCompressionFormat.StreamWithDescription streamWithDescription = backupFormat.get().decompressAndDescribe(input);
            backupDescriptionConsumer.accept(streamWithDescription.backupDescription());
            return streamWithDescription.inputStream();
        }
        CompressionFormat format = DumpFormatSelector.selectDumpFormat(bytes);
        if (format != null) {
            return format.decompress(input);
        }
        input.unread(bytes);
        return DumpFormatSelector.legacyDecompress(streamSupplier, input);
    }

    static InputStream legacyDecompress(ThrowingSupplier<InputStream, IOException> streamSupplier, PushbackInputStream input) throws IOException {
        return StandardCompressionFormat.decompress((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> {
            try {
                if (input.available() > 0) {
                    return input;
                }
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return (InputStream)streamSupplier.get();
        }));
    }

    private static CompressionFormat selectDumpFormat(byte[] bytes) {
        return switch (new String(bytes)) {
            case "DZV1" -> new DumpZstdFormatV1();
            case "DGV1" -> new DumpGzipFormatV1();
            default -> null;
        };
    }

    public static CompressionFormat selectFormat() {
        return DumpFormatSelector.selectFormat(null);
    }

    public static CompressionFormat selectFormat(PrintStream err) {
        if (StandardCompressionFormat.selectCompressionFormat(err) == StandardCompressionFormat.ZSTD) {
            return new DumpZstdFormatV1();
        }
        return new DumpGzipFormatV1();
    }
}

