/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupTarFormatV1;
import org.neo4j.dbms.archive.backup.BackupTarFormatV2;
import org.neo4j.dbms.archive.backup.BackupZstdFormatV1;
import org.neo4j.dbms.archive.backup.BackupZstdFormatV2;
import org.neo4j.function.ThrowingSupplier;

public class BackupFormatSelector {
    private BackupFormatSelector() {
    }

    public static List<BackupCompressionFormat> availableFormats() {
        return List.of(new BackupZstdFormatV1(), new BackupTarFormatV1(), new BackupZstdFormatV2(), new BackupTarFormatV2());
    }

    public static BackupCompressionFormat selectFormat(boolean compress) {
        return compress ? new BackupZstdFormatV2() : new BackupTarFormatV2();
    }

    public static BackupDescription readDescription(InputStream inputStream) throws IOException {
        return BackupFormatSelector.selectFormat(inputStream).readMetadata(inputStream);
    }

    public static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException {
        InputStream inputStream = (InputStream)streamSupplier.get();
        return BackupFormatSelector.selectFormat(inputStream).decompress(inputStream);
    }

    private static BackupCompressionFormat selectFormat(InputStream inputStream) throws IOException {
        String magicPrefix = new String(inputStream.readNBytes(4));
        return BackupFormatSelector.selectFormat(magicPrefix).orElseThrow(() -> new IllegalArgumentException("Unsupported format backup format: " + magicPrefix));
    }

    public static Optional<BackupCompressionFormat> selectFormat(String magicPrefix) {
        return switch (magicPrefix) {
            case "BZV1" -> Optional.of(new BackupZstdFormatV1());
            case "BTV1" -> Optional.of(new BackupTarFormatV1());
            case "BZV2" -> Optional.of(new BackupZstdFormatV2());
            case "BTV2" -> Optional.of(new BackupTarFormatV2());
            default -> Optional.empty();
        };
    }
}

