/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DatabaseDetailsExtras;
import org.neo4j.dbms.database.TopologyInfoService;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.storageengine.StoreFileClosedException;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DefaultDatabaseDetailsExtrasProvider {
    public static final long COMMITTED_TX_ID_NOT_AVAILABLE = -1L;
    private final DatabaseContextProvider<?> databaseContextProvider;

    public DefaultDatabaseDetailsExtrasProvider(DatabaseContextProvider<?> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    public DatabaseDetailsExtras extraDetails(DatabaseId databaseId, TopologyInfoService.RequestedExtras detailsLevel) {
        if (detailsLevel.txInfo() || detailsLevel.storeInfo()) {
            Optional<Long> lastCommittedTxId = Optional.empty();
            Optional<Long> lastAppendIndex = Optional.empty();
            Optional<StoreId> storeId = Optional.empty();
            Optional<ExternalStoreId> externalStoreId = Optional.empty();
            Optional<DatabaseContext> context = this.databaseContextProvider.getDatabaseContext(databaseId).filter(databaseContext -> databaseContext.database().isStarted());
            if (detailsLevel.txInfo()) {
                lastCommittedTxId = DefaultDatabaseDetailsExtrasProvider.fetchLastCommittedTxId(context);
                lastAppendIndex = DefaultDatabaseDetailsExtrasProvider.fetchLastAppendIndex(context);
            }
            if (detailsLevel.storeInfo()) {
                storeId = DefaultDatabaseDetailsExtrasProvider.fetchStoreId(context);
                externalStoreId = DefaultDatabaseDetailsExtrasProvider.fetchExternalStoreId(context);
            }
            return new DatabaseDetailsExtras(lastCommittedTxId, lastAppendIndex, storeId, externalStoreId);
        }
        return DatabaseDetailsExtras.EMPTY;
    }

    private static Optional<Long> fetchLastAppendIndex(Optional<? extends DatabaseContext> context) {
        return context.map(DatabaseContext::dependencies).flatMap(dependencyResolver -> dependencyResolver.resolveOptionalDependency(LogMetadataProvider.class)).flatMap(applyIndexProvider -> Optional.of(applyIndexProvider.getLastCommittedBatch().appendIndex()));
    }

    private static Optional<Long> fetchLastCommittedTxId(Optional<? extends DatabaseContext> context) {
        return context.map(DatabaseContext::dependencies).flatMap(dependencyResolver -> dependencyResolver.resolveOptionalDependency(TransactionIdStore.class)).flatMap(transactionIdStore -> {
            try {
                return Optional.of(transactionIdStore.getLastCommittedTransactionId());
            }
            catch (StoreFileClosedException e) {
                return Optional.empty();
            }
        });
    }

    private static Optional<StoreId> fetchStoreId(Optional<? extends DatabaseContext> context) {
        return context.flatMap(c -> {
            try {
                return Optional.of(c.database().getStoreId());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        });
    }

    private static Optional<ExternalStoreId> fetchExternalStoreId(Optional<? extends DatabaseContext> context) {
        return context.map(DatabaseContext::dependencies).flatMap(dependencyResolver -> dependencyResolver.resolveOptionalDependency(StoreIdProvider.class)).flatMap(storeIdProvider -> {
            try {
                return Optional.of(storeIdProvider.getExternalStoreId());
            }
            catch (StoreFileClosedException e) {
                return Optional.empty();
            }
        });
    }
}

