/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.time.Duration;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.dbms.routing.RoutingTableServiceHelpers;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.values.virtual.MapValue;

public class CommunityRoutingService
implements RoutingService {
    private final DatabaseContextProvider<?> databaseContextProvider;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final ConnectorPortRegister portRegister;
    private final boolean boltDisabled;
    private final long ttl;
    private final SocketAddress localAdvertisedAddress;

    public CommunityRoutingService(DatabaseContextProvider<?> databaseContextProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectorPortRegister portRegister, Config config) {
        this.databaseContextProvider = databaseContextProvider;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.portRegister = portRegister;
        this.boltDisabled = (Boolean)config.get(BoltConnector.enabled) == false;
        this.ttl = ((Duration)config.get(GraphDatabaseSettings.routing_ttl)).toMillis();
        this.localAdvertisedAddress = (SocketAddress)config.get(BoltConnector.advertised_address);
    }

    @Override
    public RoutingResult route(String databaseName, String user, MapValue routingContext) throws RoutingException {
        Optional context;
        if (databaseName == null || databaseName.isEmpty() || databaseName.isBlank()) {
            databaseName = this.defaultDatabaseResolver.defaultDatabase(user);
        }
        if ((context = this.databaseContextProvider.getDatabaseContext(databaseName)).isEmpty()) {
            throw RoutingTableServiceHelpers.databaseNotFoundException(databaseName);
        }
        if (!((DatabaseContext)context.get()).database().getDatabaseAvailabilityGuard().isAvailable()) {
            throw RoutingException.routingTableForUnavailableDb(databaseName);
        }
        if (this.boltDisabled) {
            throw RoutingException.boltNotEnabled(databaseName);
        }
        SocketAddress singleAddress = RoutingTableServiceHelpers.ensureBoltAddressIsUsable(routingContext, this.portRegister, this.localAdvertisedAddress);
        return RoutingResult.single(singleAddress, this.ttl);
    }
}

