/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.common.panic.PanicEventHandler;
import org.neo4j.common.panic.PanicReason;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.routing.ClientRoutingDomainChecker;
import org.neo4j.dbms.routing.ClientSideRoutingTableProvider;
import org.neo4j.dbms.routing.InstanceClusterView;
import org.neo4j.dbms.routing.RoutingAddressRewriter;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.dbms.routing.RoutingTableServiceHelpers;
import org.neo4j.dbms.routing.RoutingTableServiceValidator;
import org.neo4j.dbms.routing.ServerSideRoutingTableProvider;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class DefaultRoutingService
implements RoutingService,
PanicEventHandler {
    private final InternalLog log;
    private final RoutingTableServiceValidator validator;
    private final ClientSideRoutingTableProvider clientSideRoutingTableProvider;
    private final ServerSideRoutingTableProvider serverSideRoutingTableProvider;
    private final ClientRoutingDomainChecker clientRoutingDomainChecker;
    private final Supplier<GraphDatabaseSettings.RoutingMode> defaultRouterSupplier;
    private final Supplier<Boolean> boltEnabled;
    private final InstanceClusterView instanceClusterView;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final DatabaseReferenceRepository databaseReferenceRepo;
    private final boolean echoRoutingContextAddressWhenAlone;
    private volatile PanicReason panicReason;
    private final boolean clientProvidedRouterEnabled;
    private final List<String> clientProvidedRouterPrefixes;
    private final Duration clientProvidedRouterPrefixRotationPeriod;
    private final String clientProvidedRouterSuffix;
    private final Clock clock;
    private final RoutingAddressRewriter addressRewriter;

    public DefaultRoutingService(InternalLogProvider logProvider, RoutingTableServiceValidator validator, ClientSideRoutingTableProvider clientSideRoutingTableProvider, ServerSideRoutingTableProvider serverSideRoutingTableProvider, ClientRoutingDomainChecker clientRoutingDomainChecker, Config config, InstanceClusterView instanceClusterView, DefaultDatabaseResolver defaultDatabaseResolver, DatabaseReferenceRepository databaseReferenceRepo, boolean echoRoutingContextAddressWhenAlone, Clock clock) {
        this.log = logProvider.getLog(this.getClass());
        this.validator = validator;
        this.clientSideRoutingTableProvider = clientSideRoutingTableProvider;
        this.serverSideRoutingTableProvider = serverSideRoutingTableProvider;
        this.clientRoutingDomainChecker = clientRoutingDomainChecker;
        this.defaultRouterSupplier = () -> (GraphDatabaseSettings.RoutingMode)config.get(GraphDatabaseSettings.routing_default_router);
        this.boltEnabled = () -> (Boolean)config.get(BoltConnector.enabled);
        this.instanceClusterView = instanceClusterView;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.echoRoutingContextAddressWhenAlone = echoRoutingContextAddressWhenAlone;
        this.clientProvidedRouterEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.client_provided_router_enabled);
        this.clientProvidedRouterPrefixes = (List)config.get(GraphDatabaseInternalSettings.client_provided_router_prefixes);
        this.clientProvidedRouterSuffix = (String)config.get(GraphDatabaseInternalSettings.client_provided_router_suffix);
        this.clientProvidedRouterPrefixRotationPeriod = (Duration)config.get(GraphDatabaseInternalSettings.client_provided_router_prefix_rotation_period);
        this.clock = clock;
        if (((Boolean)config.get(GraphDatabaseInternalSettings.routing_address_rewriting_enabled)).booleanValue()) {
            String template = (String)config.get(GraphDatabaseInternalSettings.routing_address_rewriting_template);
            String clientRegex = (String)config.get(GraphDatabaseInternalSettings.routing_address_rewriting_client_regex);
            String tableRegex = (String)config.get(GraphDatabaseInternalSettings.routing_address_rewriting_table_regex);
            this.addressRewriter = new RoutingAddressRewriter(template, clientRegex, tableRegex);
        } else {
            this.addressRewriter = null;
        }
    }

    @Override
    public RoutingResult route(String databaseName, String user, MapValue routingContext) throws RoutingException {
        this.assertNotInPanic();
        DatabaseReference databaseReference = this.extractDatabaseReference(databaseName, user);
        this.assertDatabaseExists(databaseReference);
        this.assertBoltConnectorEnabled(databaseReference);
        this.assertNotIllegalAliasChain(databaseReference, routingContext);
        return this.routeInternal(databaseReference, routingContext);
    }

    private void assertNotInPanic() throws RoutingException {
        if (this.panicReason != null) {
            throw RoutingException.serverPanic(this.panicReason.toString());
        }
    }

    private RoutingResult routeInternal(DatabaseReference databaseReference, MapValue routingContext) throws RoutingException {
        boolean shouldReplaceRouter;
        RoutingResult result;
        this.assertBoltConnectorEnabled(databaseReference);
        Optional<SocketAddress> clientProvidedAddress = RoutingTableServiceHelpers.findClientProvidedAddress(routingContext, 7687, this.log);
        boolean isInternalRef = databaseReference instanceof DatabaseReferenceImpl.Internal;
        if (!isInternalRef) {
            result = this.serverSideRoutingTableProvider.getServerSideRoutingTable(routingContext);
        } else {
            GraphDatabaseSettings.RoutingMode defaultRouter = this.defaultRouterSupplier.get();
            if (this.configAllowsForClientSideRouting(defaultRouter, clientProvidedAddress)) {
                this.validator.isValidForClientSideRouting((DatabaseReferenceImpl.Internal)databaseReference);
                result = this.clientSideRoutingTableProvider.getRoutingResultForClientSideRouting((DatabaseReferenceImpl.Internal)databaseReference, routingContext);
            } else {
                this.validator.isValidForServerSideRouting((DatabaseReferenceImpl.Internal)databaseReference);
                result = this.serverSideRoutingTableProvider.getServerSideRoutingTable(routingContext);
            }
        }
        Boolean validClientProvidedRouterExists = clientProvidedAddress.map(a -> a.getHostname().endsWith(this.clientProvidedRouterSuffix)).orElse(false);
        boolean bl = shouldReplaceRouter = this.clientProvidedRouterEnabled && validClientProvidedRouterExists != false;
        if (shouldReplaceRouter) {
            result = this.replaceRouterWithClientProvidedAddress(result, clientProvidedAddress.get());
        }
        if (this.addressRewriter != null && clientProvidedAddress.isPresent()) {
            result = this.addressRewriter.rewrite(result, clientProvidedAddress.get());
        }
        DefaultRoutingService.assertRoutingResultNotEmpty(result, databaseReference);
        return result;
    }

    private DatabaseReference extractDatabaseReference(String databaseName, String user) throws RoutingException {
        if (databaseName == null || databaseName.isEmpty()) {
            databaseName = this.defaultDatabaseResolver.defaultDatabase(user);
        }
        String finalDatabaseName = databaseName;
        DatabaseReference resolvedReference = (DatabaseReference)this.databaseReferenceRepo.getByDisplayName(databaseName).orElseThrow(() -> RoutingTableServiceHelpers.databaseNotFoundException(finalDatabaseName));
        if (resolvedReference.namespace().isPresent()) {
            throw RoutingTableServiceHelpers.databaseNotFoundException(finalDatabaseName);
        }
        return resolvedReference;
    }

    private boolean configAllowsForClientSideRouting(GraphDatabaseSettings.RoutingMode defaultRouter, Optional<SocketAddress> clientProvidedAddress) {
        if (this.echoRoutingContextAddressWhenAlone && this.instanceClusterView.amIAlone()) {
            return false;
        }
        switch (defaultRouter) {
            case CLIENT: {
                return true;
            }
            case SERVER: {
                return clientProvidedAddress.isEmpty() || this.clientRoutingDomainChecker.shouldGetClientRouting(clientProvidedAddress.get());
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(defaultRouter));
    }

    private void assertBoltConnectorEnabled(DatabaseReference databaseReference) throws RoutingException {
        if (!this.boltEnabled.get().booleanValue()) {
            throw RoutingException.boltNotEnabled(databaseReference.alias().name());
        }
    }

    private static void assertRoutingResultNotEmpty(RoutingResult result, DatabaseReference databaseReference) throws RoutingException {
        if (result.containsNoEndpoints()) {
            throw RoutingException.routingTableIsEmpty(databaseReference.alias().toString());
        }
    }

    private void assertDatabaseExists(DatabaseReference databaseReference) throws RoutingException {
        this.databaseReferenceRepo.getByAlias(databaseReference.alias()).orElseThrow(() -> RoutingTableServiceHelpers.databaseNotFoundException(databaseReference.alias().name()));
    }

    private void assertNotIllegalAliasChain(DatabaseReference databaseReference, MapValue routingContext) throws RoutingException {
        boolean sourceAliasIsPresent;
        boolean refIsRemoteAlias = databaseReference instanceof DatabaseReferenceImpl.External;
        AnyValue sourceAlias = routingContext.get("alias");
        boolean bl = sourceAliasIsPresent = sourceAlias != null && sourceAlias != Values.NO_VALUE;
        if (refIsRemoteAlias && sourceAliasIsPresent) {
            String sourceAliasString = ((TextValue)sourceAlias).stringValue();
            throw RoutingException.aliasChainsNotPermitted(databaseReference.alias().name(), sourceAliasString);
        }
    }

    private RoutingResult replaceRouterWithClientProvidedAddress(RoutingResult oldResult, SocketAddress clientProvidedAddress) {
        long millisSinceEpoch = this.clock.instant().toEpochMilli();
        String prefix = DefaultRoutingService.calculateClientProvidedRouterPrefix(this.clientProvidedRouterPrefixes, this.clientProvidedRouterPrefixRotationPeriod.toMillis(), millisSinceEpoch);
        return new RoutingResult(List.of(new SocketAddress(String.format("%s-%s", prefix, clientProvidedAddress.getHostname()), clientProvidedAddress.getPort())), oldResult.writeEndpoints(), oldResult.readEndpoints(), oldResult.ttlMillis());
    }

    @VisibleForTesting
    public static String calculateClientProvidedRouterPrefix(List<String> prefixes, long rotationPeriodMills, long millisSinceEpoch) {
        long periodsSinceEpoch = millisSinceEpoch / rotationPeriodMills;
        int prefixToSelect = (int)(periodsSinceEpoch % (long)prefixes.size());
        return prefixes.get(prefixToSelect);
    }

    public void onPanic(PanicReason reason, Throwable error) {
        this.panicReason = reason;
    }
}

