/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.util.VisibleForTesting;

public class RoutingAddressRewriter {
    private final String template;
    private final Pattern clientRegex;
    private final Pattern tableRegex;

    public RoutingAddressRewriter(String template, String clientRegex, String tableRegex) {
        this.template = template;
        this.clientRegex = Pattern.compile(clientRegex);
        this.tableRegex = Pattern.compile(tableRegex);
    }

    public RoutingResult rewrite(RoutingResult routingIn, SocketAddress clientAddress) {
        List<SocketAddress> routeList = routingIn.routeEndpoints().stream().map(src -> this.rewriteAddress((SocketAddress)src, clientAddress)).toList();
        List<SocketAddress> writeList = routingIn.writeEndpoints().stream().map(src -> this.rewriteAddress((SocketAddress)src, clientAddress)).toList();
        List<SocketAddress> readList = routingIn.readEndpoints().stream().map(src -> this.rewriteAddress((SocketAddress)src, clientAddress)).toList();
        return new RoutingResult(routeList, writeList, readList, routingIn.ttlMillis());
    }

    @VisibleForTesting
    SocketAddress rewriteAddress(SocketAddress tableAddress, SocketAddress clientAddress) {
        Matcher tableAddressMatcher = this.tableRegex.matcher(tableAddress.getHostname());
        Matcher clientAddressMatcher = this.clientRegex.matcher(clientAddress.getHostname());
        if (tableAddressMatcher.matches() && clientAddressMatcher.matches()) {
            String matchText;
            int i;
            String result = this.template;
            for (i = 1; i <= tableAddressMatcher.groupCount(); ++i) {
                matchText = String.format("${t:%d}", i);
                result = result.replace(matchText, tableAddressMatcher.group(i));
            }
            for (i = 1; i <= clientAddressMatcher.groupCount(); ++i) {
                matchText = String.format("${c:%d}", i);
                result = result.replace(matchText, clientAddressMatcher.group(i));
            }
            int port = tableAddress.getPort();
            return new SocketAddress(result, port);
        }
        return tableAddress;
    }
}

