/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Map;
import java.util.Optional;

public record SeedURI(Optional<String> singleUri, Map<String, String> uriMap) {
    public static final SeedURI EMPTY = new SeedURI(Optional.empty(), Map.of());

    public static SeedURI single(String singleUri) {
        return new SeedURI(Optional.of(singleUri), Map.of());
    }

    public static SeedURI sharded(Map<String, String> uriMap) {
        return new SeedURI(Optional.empty(), Map.copyOf(uriMap));
    }

    public boolean isEmpty() {
        return this.singleUri.isEmpty() && this.uriMap.isEmpty();
    }

    public Optional<String> best(String databaseName) {
        return Optional.ofNullable(this.uriMap.get(databaseName)).or(this::singleUri);
    }
}

