/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.Arrays;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.internal.id.indexed.IdRange;

public class IllegalIdTransitionException
extends IllegalStateException {
    private final long[] ids;

    public IllegalIdTransitionException(long idRangeIdx, long firstId, long lastId, long into, long from) {
        super(String.format("Illegal addition ID state for range: %d (IDs %d-%d) transition%ninto: %s%nfrom: %s, illegal IDs: %s", idRangeIdx, firstId, lastId, IdRange.toPaddedBinaryString(into), IdRange.toPaddedBinaryString(from), Arrays.toString(IllegalIdTransitionException.findCollidingIds(firstId, into, from))));
        this.ids = IllegalIdTransitionException.findCollidingIds(firstId, into, from);
    }

    public long[] ids() {
        return this.ids;
    }

    private static long[] findCollidingIds(long firstId, long into, long from) {
        MutableLongList list = LongLists.mutable.empty();
        for (int i = 0; i < 64; ++i) {
            long mask = 1L << i;
            if ((into & mask) == 0L || (from & mask) == 0L) continue;
            list.add(firstId + (long)i);
        }
        return list.toArray();
    }
}

