/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.util.Preconditions;

class MpmcLongQueue
implements ConcurrentLongQueue {
    private static final long EMPTY_VALUE = -1L;
    private final long idxMask;
    private final AtomicLongArray array;
    private final AtomicLong readSeq = new AtomicLong();
    private final AtomicLong writeSeq = new AtomicLong();

    MpmcLongQueue(int capacity) {
        Preconditions.requirePowerOfTwo((long)capacity);
        this.idxMask = capacity - 1;
        long[] array = new long[capacity];
        Arrays.fill(array, -1L);
        this.array = new AtomicLongArray(array);
    }

    @Override
    public boolean offer(long value) {
        long currentWriteSeq;
        int writeIdx;
        assert (value != -1L);
        do {
            int readIdx;
            currentWriteSeq = this.writeSeq.get();
            long currentReadSeq = this.readSeq.get();
            writeIdx = this.idx(currentWriteSeq);
            if (writeIdx != (readIdx = this.idx(currentReadSeq)) || currentWriteSeq == currentReadSeq) continue;
            return false;
        } while (this.array.get(writeIdx) != -1L || !this.writeSeq.compareAndSet(currentWriteSeq, currentWriteSeq + 1L));
        this.array.set(writeIdx, value);
        return true;
    }

    @Override
    public long takeOrDefault(long defaultValue) {
        long currentReadSeq;
        int idx;
        long value;
        do {
            long currentWriteSeq;
            if ((currentReadSeq = this.readSeq.get()) != (currentWriteSeq = this.writeSeq.get())) continue;
            return defaultValue;
        } while ((value = this.array.get(idx = this.idx(currentReadSeq))) == -1L || !this.readSeq.compareAndSet(currentReadSeq, currentReadSeq + 1L));
        this.array.set(idx, -1L);
        return value;
    }

    @Override
    public long takeInRange(long minBoundary, long maxBoundary) {
        int idx;
        long currentReadSeq;
        long value;
        do {
            long currentWriteSeq;
            if ((currentReadSeq = this.readSeq.get()) == (currentWriteSeq = this.writeSeq.get())) {
                return Long.MAX_VALUE;
            }
            idx = this.idx(currentReadSeq);
            value = this.array.get(idx);
            if (value < maxBoundary && value >= minBoundary) continue;
            return Long.MAX_VALUE;
        } while (value == -1L || !this.readSeq.compareAndSet(currentReadSeq, currentReadSeq + 1L));
        this.array.set(idx, -1L);
        return value;
    }

    @Override
    public int size() {
        return Math.toIntExact(Math.max(0L, this.writeSeq.get() - this.readSeq.get()));
    }

    @Override
    public int availableSpace() {
        return this.array.length() - this.size();
    }

    @Override
    public void clear() {
        this.readSeq.set(this.writeSeq.get());
    }

    private int idx(long seq) {
        return Math.toIntExact(seq & this.idxMask);
    }
}

