/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.time.Duration;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.ToolingMemoryCalculations;
import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import picocli.CommandLine;

public interface Converters {

    public static class DurationConverter
    implements CommandLine.ITypeConverter<Duration> {
        public Duration convert(String value) throws Exception {
            try {
                return (Duration)SettingValueParsers.DURATION.parse(value);
            }
            catch (Exception ex) {
                throw new CommandLine.TypeConversionException(String.format("'%s' is not a valid duration. %s", value, ex.getMessage()));
            }
        }
    }

    public static class MaxOffHeapMemoryConverter
    implements CommandLine.ITypeConverter<Long> {
        public static final String DESCRIPTION = "Maximum memory that neo4j-admin can use for various data structures and caching to improve performance. Values can be plain numbers, such as 10000000, or 20G for 20 gigabytes. It can also be specified as a percentage of the available memory, for example 70%%.";
        public static final String OPTION_NAME = "--max-off-heap-memory";

        public Long convert(String value) throws Exception {
            return new ToolingMemoryCalculations(ToolingMemoryCalculations.NOTIFY_SYS_ERR).calculateMaxAvailableOffHeapMemory(value);
        }
    }

    public static class DatabaseNamePatternConverter
    implements CommandLine.ITypeConverter<DatabaseNamePattern> {
        public DatabaseNamePattern convert(String name) {
            try {
                return new DatabaseNamePattern(name);
            }
            catch (Exception ex) {
                throw new CommandLine.TypeConversionException(String.format("Invalid database name '%s'. (%s)", name, ex));
            }
        }
    }

    public static class DatabaseNameConverter
    implements CommandLine.ITypeConverter<NormalizedDatabaseName> {
        public NormalizedDatabaseName convert(String name) {
            try {
                NormalizedDatabaseName databaseName = new NormalizedDatabaseName(name);
                DatabaseNameValidator.validateInternalDatabaseName((NormalizedDatabaseName)databaseName);
                return databaseName;
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("Invalid database name '%s'. (%s)", name, e));
            }
        }
    }

    public static class ByteUnitConverter
    implements CommandLine.ITypeConverter<Long> {
        public Long convert(String value) {
            try {
                return ByteUnit.parse((String)value);
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("cannot convert '%s' to byte units (%s)", value, e));
            }
        }
    }
}

