/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.ArrayDeque;
import java.util.Queue;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;

public class BufferingLog
implements InternalLog {
    private final Queue<LogMessage> buffer = new ArrayDeque<LogMessage>();

    public boolean isDebugEnabled() {
        return true;
    }

    public synchronized void debug(String message) {
        this.buffer.add(other -> other.debug(message));
    }

    public synchronized void debug(String message, Throwable throwable) {
        this.buffer.add(other -> other.debug(message, throwable));
    }

    public synchronized void debug(String format, Object ... arguments) {
        this.buffer.add(other -> other.debug(format, arguments));
    }

    public synchronized void info(String message) {
        this.buffer.add(other -> other.info(message));
    }

    public synchronized void info(String message, Throwable throwable) {
        this.buffer.add(other -> other.info(message, throwable));
    }

    public synchronized void info(String format, Object ... arguments) {
        this.buffer.add(other -> other.info(format, arguments));
    }

    public synchronized void warn(String message) {
        this.buffer.add(other -> other.warn(message));
    }

    public synchronized void warn(String message, Throwable throwable) {
        this.buffer.add(other -> other.warn(message, throwable));
    }

    public synchronized void warn(String format, Object ... arguments) {
        this.buffer.add(other -> other.warn(format, arguments));
    }

    public synchronized void error(String message) {
        this.buffer.add(other -> other.error(message));
    }

    public synchronized void error(String message, Throwable throwable) {
        this.buffer.add(other -> other.error(message, throwable));
    }

    public synchronized void error(String format, Object ... arguments) {
        this.buffer.add(other -> other.error(format, arguments));
    }

    public synchronized void debug(Neo4jLogMessage message) {
        this.buffer.add(other -> other.debug(message));
    }

    public synchronized void info(Neo4jLogMessage message) {
        this.buffer.add(other -> other.info(message));
    }

    public synchronized void warn(Neo4jLogMessage message) {
        this.buffer.add(other -> other.warn(message));
    }

    public synchronized void error(Neo4jLogMessage message) {
        this.buffer.add(other -> other.error(message));
    }

    public synchronized void error(Neo4jLogMessage message, Throwable throwable) {
        this.buffer.add(other -> other.error(message, throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayInto(InternalLog other) {
        Queue<LogMessage> queue = this.buffer;
        synchronized (queue) {
            LogMessage message = this.buffer.poll();
            while (message != null) {
                message.replayInto(other);
                message = this.buffer.poll();
            }
        }
    }

    @FunctionalInterface
    private static interface LogMessage {
        public void replayInto(InternalLog var1);
    }
}

