/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConfigPatternBuilder {
    private static final Map<Character, String> supportedWildcards = Map.of(Character.valueOf('?'), ".{0,1}", Character.valueOf('*'), ".+");
    private static final String wildcardCharacters = supportedWildcards.keySet().stream().map(Object::toString).collect(Collectors.joining(""));

    public static Optional<Pattern> optionalPatternFromConfigString(String pattern, int patternFlags) {
        if (!StringUtils.containsAny((CharSequence)pattern, (CharSequence)wildcardCharacters)) {
            return Optional.empty();
        }
        return Optional.of(ConfigPatternBuilder.patternFromConfigString(pattern, patternFlags));
    }

    public static Pattern patternFromConfigString(String pattern, int patternFlags) {
        return ConfigPatternBuilder.buildRegexPattern(pattern, patternFlags);
    }

    private static Pattern buildRegexPattern(String name, int patternFlags) {
        StringBuilder pattern = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (supportedWildcards.containsKey(Character.valueOf(ch))) {
                ConfigPatternBuilder.flushBuffer(buffer, pattern);
                pattern.append(supportedWildcards.get(Character.valueOf(ch)));
                continue;
            }
            buffer.append(ch);
        }
        ConfigPatternBuilder.flushBuffer(buffer, pattern);
        return Pattern.compile(pattern.toString(), patternFlags);
    }

    private static void flushBuffer(StringBuilder fromBuffer, StringBuilder toPattern) {
        if (!fromBuffer.isEmpty()) {
            toPattern.append(Pattern.quote(fromBuffer.toString()));
            fromBuffer.delete(0, Integer.MAX_VALUE);
        }
    }
}

