/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bolt.BoltFabricDatabaseService;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.memory.MemoryTracker;

public class BoltFabricDatabaseManagementService
implements BoltGraphDatabaseManagementServiceSPI {
    private final FabricExecutor fabricExecutor;
    private final FabricConfig config;
    private final TransactionManager transactionManager;
    private final FabricDatabaseManager fabricDatabaseManager;
    private final LocalGraphTransactionIdTracker transactionIdTracker;

    public BoltFabricDatabaseManagementService(FabricExecutor fabricExecutor, FabricConfig config, TransactionManager transactionManager, FabricDatabaseManager fabricDatabaseManager, LocalGraphTransactionIdTracker transactionIdTracker) {
        this.fabricExecutor = fabricExecutor;
        this.config = config;
        this.transactionManager = transactionManager;
        this.fabricDatabaseManager = fabricDatabaseManager;
        this.transactionIdTracker = transactionIdTracker;
    }

    public BoltGraphDatabaseServiceSPI database(String databaseName, MemoryTracker memoryTracker) throws UnavailableException, DatabaseNotFoundException {
        try {
            return this.getDatabase(databaseName, memoryTracker);
        }
        catch (DatabaseShutdownException | UnavailableException e) {
            throw UnavailableException.databaseUnavailable((String)databaseName, (String)String.format("Database '%s' is unavailable.", databaseName));
        }
    }

    public BoltGraphDatabaseServiceSPI getDatabase(String databaseName, MemoryTracker memoryTracker) throws UnavailableException, DatabaseNotFoundException {
        memoryTracker.allocateHeap(BoltFabricDatabaseService.SHALLOW_SIZE);
        DatabaseReference databaseReference = this.fabricDatabaseManager.getDatabaseReference(databaseName);
        return new BoltFabricDatabaseService(databaseReference, this.fabricExecutor, this.config, this.transactionManager, this.transactionIdTracker, memoryTracker);
    }
}

