/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.cypher.internal.javacompat.ResultSubscriber;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;

public class BoltQueryExecutionImpl
implements BoltQueryExecution {
    private final QueryExecutionImpl queryExecution;
    private final QuerySubscriber subscriber;

    public BoltQueryExecutionImpl(StatementResult statementResult, QuerySubscriber subscriber) {
        this.subscriber = subscriber;
        this.queryExecution = new QueryExecutionImpl(statementResult, subscriber);
    }

    public void initialize() throws Exception {
        boolean triggerArtificialDemand;
        boolean isWriteOnly = this.queryExecution.executionType().queryType() == QueryExecutionType.QueryType.WRITE;
        boolean isReadOnly = this.queryExecution.executionType().queryType() == QueryExecutionType.QueryType.READ_ONLY;
        boolean isExplain = this.queryExecution.executionType().isExplained();
        boolean noResult = this.queryExecution.fieldNames().length == 0;
        boolean bl = triggerArtificialDemand = isWriteOnly || isExplain || noResult;
        if (triggerArtificialDemand) {
            this.queryExecution.request(1L);
            this.queryExecution.await();
        }
        if (this.subscriber instanceof ResultSubscriber && (!isReadOnly || isExplain)) {
            ((ResultSubscriber)this.subscriber).materialize((QueryExecution)this.queryExecution);
        }
    }

    public QueryExecution queryExecution() {
        return this.queryExecution;
    }

    public void close() {
    }

    public void terminate() {
        this.queryExecution.cancel();
    }

    private static class QueryExecutionImpl
    implements QueryExecution {
        private final StatementResult statementResult;
        private final QuerySubscriber subscriber;
        private boolean hasMore = true;
        private boolean initialised;
        private Summary cachedSummary;

        private QueryExecutionImpl(StatementResult statementResult, QuerySubscriber subscriber) {
            this.statementResult = statementResult;
            this.subscriber = subscriber;
        }

        private Summary getSummary() {
            if (this.cachedSummary == null) {
                this.cachedSummary = this.statementResult.consume();
            }
            return this.cachedSummary;
        }

        public QueryExecutionType executionType() {
            return this.statementResult.executionType();
        }

        public ExecutionPlanDescription executionPlanDescription() {
            return this.getSummary().executionPlanDescription();
        }

        public Iterable<Notification> getNotifications() {
            return this.getSummary().getNotifications();
        }

        public Iterable<GqlStatusObject> getGqlStatusObjects() {
            return this.getSummary().getGqlStatusObjects();
        }

        public String[] fieldNames() {
            return this.statementResult.columns().toArray(new String[0]);
        }

        public void request(long numberOfRecords) throws Exception {
            if (!this.hasMore) {
                return;
            }
            if (!this.initialised) {
                this.initialised = true;
                this.subscriber.onResult(this.statementResult.columns().size());
            }
            try {
                int i = 0;
                while ((long)i < numberOfRecords) {
                    Record record = this.statementResult.next();
                    if (record == null) {
                        this.hasMore = false;
                        this.subscriber.onResultCompleted(this.getSummary().getQueryStatistics());
                        return;
                    }
                    this.subscriber.onRecord();
                    this.publishFields(record);
                    this.subscriber.onRecordCompleted();
                    ++i;
                }
            }
            catch (Exception e) {
                throw Exceptions.transformUnexpectedError((Status)Status.Statement.ExecutionFailed, e);
            }
        }

        private void publishFields(Record record) throws Exception {
            for (int i = 0; i < this.statementResult.columns().size(); ++i) {
                this.subscriber.onField(i, record.getValue(i));
            }
        }

        public void cancel() {
            this.getSummary();
        }

        public boolean await() {
            return this.hasMore;
        }
    }
}

