/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayList;
import java.util.Map;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.SingleQueryFragmentExecutor;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.QueryInput;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.StatementResults;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.notifications.NotificationImplementation;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;
import scala.jdk.javaapi.CollectionConverters;

class StandardQueryExecutor
extends SingleQueryFragmentExecutor {
    private final Fragment.Exec fragment;

    StandardQueryExecutor(Fragment.Exec fragment, FabricPlanner.PlannerInstance plannerInstance, FabricTransaction.FabricExecutionContext ctx, UseEvaluation.Instance useEvaluator, FabricPlan plan, MapValue queryParams, AccessMode accessMode, QueryStatementLifecycles.StatementLifecycle lifecycle, QueryRoutingMonitor queryRoutingMonitor, SingleQueryFragmentExecutor.Tracer tracer, SingleQueryFragmentExecutor.FragmentExecutor fragmentExecutor) {
        super(plannerInstance, ctx, useEvaluator, plan, queryParams, accessMode, lifecycle, queryRoutingMonitor, tracer, fragmentExecutor);
        this.fragment = fragment;
    }

    FragmentResult run(Record argument) {
        SingleQueryFragmentExecutor.PrepareResult prepareResult = this.prepare(this.fragment, argument);
        MapValue parameters = this.addParamsFromRecord(this.queryParams(), prepareResult.argumentValues(), CollectionConverters.asJava(this.fragment.parameters()), prepareResult.graphWithNotification().graph().name().name());
        ArrayList<NotificationImplementation> notifications = new ArrayList<NotificationImplementation>();
        if (prepareResult.graphWithNotification().notification().isDefined()) {
            notifications.add((NotificationImplementation)prepareResult.graphWithNotification().notification().get());
        }
        return this.doExecuteFragment(this.fragment, parameters, prepareResult.graphWithNotification().graph(), prepareResult.transactionMode(), () -> this.fragmentExecutor().run(this.fragment.input(), argument), notifications);
    }

    @Override
    FragmentResult runRemote(Location.Remote location, ExecutionOptions options, String query, TransactionMode transactionMode, MapValue params) {
        StatementResult result = this.ctx().getRemote().run(location, options, query, transactionMode, params);
        return StatementResults.toFragmentResult(result);
    }

    @Override
    FragmentResult runLocal(Location.Local location, TransactionMode transactionMode, QueryStatementLifecycles.StatementLifecycle parentLifecycle, FullyParsedQuery query, MapValue params, final FragmentResult input, ExecutionOptions executionOptions, Boolean targetsComposite) {
        QueryInput queryInput = new QueryInput(){

            @Override
            public Record next() {
                return input.next();
            }

            @Override
            public void consume() {
                input.consume();
            }
        };
        StatementResult result = this.ctx().getLocal().run(location, transactionMode, parentLifecycle, query, params, queryInput, executionOptions, targetsComposite);
        return StatementResults.toFragmentResult(result);
    }

    private MapValue addParamsFromRecord(MapValue params, Map<String, AnyValue> record, Map<String, String> bindings, String graphName) {
        int resultSize = params.size() + bindings.size();
        if (resultSize == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(resultSize);
        params.foreach((arg_0, arg_1) -> ((MapValueBuilder)builder).add(arg_0, arg_1));
        bindings.forEach((var, par) -> builder.add(par, this.validateValue((AnyValue)record.get(var), (String)var, graphName)));
        return builder.build();
    }
}

