/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.fabric.executor.QueryTypes;
import org.neo4j.fabric.stream.DelegatingFragmentResult;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.PlanlessSummary;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.values.AnyValue;

public final class StatementResults {
    private StatementResults() {
    }

    public static StatementResult emptyStream(final List<String> columns, final Summary summary, final QueryExecutionType executionType) {
        return new StatementResult(){

            @Override
            public List<String> columns() {
                return columns;
            }

            @Override
            public Record next() {
                return null;
            }

            @Override
            public Summary consume() {
                return summary;
            }

            @Override
            public QueryExecutionType executionType() {
                return executionType;
            }
        };
    }

    public static FragmentResult toFragmentResult(final StatementResult statementResult) {
        return new FragmentResult(){

            @Override
            public List<String> columns() {
                return statementResult.columns();
            }

            @Override
            public Record next() {
                return statementResult.next();
            }

            @Override
            public PlanlessSummary consume() {
                Summary summary = statementResult.consume();
                return new PlanlessSummary(summary.getNotifications(), summary.getGqlStatusObjects(), summary.getQueryStatistics());
            }

            @Override
            public QueryExecutionType executionType() {
                return statementResult.executionType();
            }
        };
    }

    public static FragmentResult mergeUnion(final FragmentResult lhs, final FragmentResult rhs) {
        boolean rearangeColumns;
        boolean bl = rearangeColumns = !lhs.columns().equals(rhs.columns());
        final List<Integer> rhsOutputOrder = rearangeColumns ? lhs.columns().stream().map(rhs.columns()::indexOf).toList() : null;
        final QueryExecutionType executionType = StatementResults.merge(lhs.executionType(), rhs.executionType());
        return new FragmentResult(){
            boolean lhsCompletd = false;

            @Override
            public List<String> columns() {
                return lhs.columns();
            }

            @Override
            public Record next() {
                Record record;
                if (!this.lhsCompletd) {
                    record = lhs.next();
                    if (record != null) {
                        return record;
                    }
                    this.lhsCompletd = true;
                }
                record = rhs.next();
                if (rearangeColumns && record != null) {
                    return this.rearrangeRecordOrder(record, rhsOutputOrder);
                }
                return record;
            }

            @Override
            public PlanlessSummary consume() {
                PlanlessSummary lhsSummary = lhs.consume();
                PlanlessSummary rhsSummary = rhs.consume();
                return PlanlessSummary.merge(lhsSummary, rhsSummary);
            }

            @Override
            public QueryExecutionType executionType() {
                return executionType;
            }

            private Record rearrangeRecordOrder(Record record, List<Integer> columns) {
                List<AnyValue> values = columns.stream().map(record::getValue).collect(Collectors.toList());
                return Records.of(values);
            }
        };
    }

    public static QueryExecutionType merge(QueryExecutionType a, QueryExecutionType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return QueryTypes.merge(a, b);
    }

    public static FragmentResult distinct(FragmentResult original) {
        final HashSet records = new HashSet();
        return new DelegatingFragmentResult(original){

            @Override
            public Record next() {
                Record record;
                do {
                    if ((record = this.delegate.next()) != null) continue;
                    return null;
                } while (!records.add(record));
                return record;
            }
        };
    }

    public static FragmentResult emptyFragment() {
        return new FragmentResult(){

            @Override
            public List<String> columns() {
                return List.of();
            }

            @Override
            public Record next() {
                return null;
            }

            @Override
            public PlanlessSummary consume() {
                return new PlanlessSummary(Collections.emptyList(), Collections.emptyList(), QueryStatistics.EMPTY);
            }

            @Override
            public QueryExecutionType executionType() {
                return null;
            }
        };
    }

    public static FragmentResult oneRecord(final List<String> columns, final Record r, final QueryExecutionType executionType) {
        return new FragmentResult(){
            private Record record;
            {
                this.record = r;
            }

            @Override
            public List<String> columns() {
                return columns;
            }

            @Override
            public Record next() {
                Record result = this.record;
                if (this.record != null) {
                    this.record = null;
                }
                return result;
            }

            @Override
            public PlanlessSummary consume() {
                return new PlanlessSummary(Collections.emptyList(), Collections.emptyList(), QueryStatistics.EMPTY);
            }

            @Override
            public QueryExecutionType executionType() {
                return executionType;
            }
        };
    }
}

