/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricProcedures;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.FabricTransactionImpl;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.FabricTransactionMonitor;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.time.SystemNanoClock;

public class TransactionManager
extends LifecycleAdapter {
    private final FabricRemoteExecutor remoteExecutor;
    private final FabricLocalExecutor localExecutor;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final FabricTransactionMonitor transactionMonitor;
    private final AbstractSecurityLog securityLog;
    private final SystemNanoClock clock;
    private final Set<FabricTransactionImpl> openTransactions = ConcurrentHashMap.newKeySet();
    private final long awaitActiveTransactionDeadlineMillis;
    private final AvailabilityGuard availabilityGuard;
    private final GlobalProcedures globalProcedures;
    private final CatalogManager catalogManager;
    private final CallableExecutor executor;

    public TransactionManager(FabricRemoteExecutor remoteExecutor, FabricLocalExecutor localExecutor, CatalogManager catalogManager, FabricTransactionMonitor transactionMonitor, AbstractSecurityLog securityLog, SystemNanoClock clock, Config config, AvailabilityGuard availabilityGuard, ErrorReporter errorReporter, GlobalProcedures globalProcedures, CallableExecutor executor) {
        this.remoteExecutor = remoteExecutor;
        this.localExecutor = localExecutor;
        this.catalogManager = catalogManager;
        this.config = config;
        this.errorReporter = errorReporter;
        this.transactionMonitor = transactionMonitor;
        this.securityLog = securityLog;
        this.clock = clock;
        this.awaitActiveTransactionDeadlineMillis = ((Duration)config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
        this.availabilityGuard = availabilityGuard;
        this.globalProcedures = globalProcedures;
        this.executor = executor;
    }

    public FabricTransaction begin(FabricTransactionInfo transactionInfo, TransactionBookmarkManager transactionBookmarkManager) {
        if (this.availabilityGuard.isShutdown()) {
            throw DatabaseShutdownException.databaseUnavailable((String)(transactionInfo != null ? transactionInfo.getSessionDatabaseReference().name() : "neo4j"));
        }
        DatabaseReference sessionDb = transactionInfo.getSessionDatabaseReference();
        transactionInfo.getLoginContext().authorize(LoginContext.IdLookup.EMPTY, (PrivilegeDatabaseReference)sessionDb, this.securityLog);
        FabricProcedures procedures = new FabricProcedures(this.globalProcedures.getCurrentView());
        FabricTransactionImpl fabricTransaction = new FabricTransactionImpl(transactionInfo, transactionBookmarkManager, this.remoteExecutor, this.localExecutor, procedures, this.errorReporter, this, this.catalogManager.currentCatalog(), this.catalogManager, sessionDb instanceof DatabaseReferenceImpl.Composite, this.clock, TraceProviderFactory.getTraceProvider((Config)this.config), this.executor);
        this.openTransactions.add(fabricTransaction);
        this.transactionMonitor.startMonitoringTransaction(fabricTransaction, transactionInfo);
        return fabricTransaction;
    }

    public void stop() {
        Collection<FabricTransactionImpl> nonLocalTransaction = this.collectNonLocalTransactions();
        if (nonLocalTransaction.isEmpty()) {
            return;
        }
        this.awaitTransactionsClosedWithinTimeout(nonLocalTransaction);
        nonLocalTransaction.forEach(tx -> tx.markForTermination((Status)Status.Transaction.Terminated));
    }

    private Collection<FabricTransactionImpl> collectNonLocalTransactions() {
        return this.openTransactions.stream().filter(tx -> !tx.isLocal()).collect(Collectors.toList());
    }

    private void awaitTransactionsClosedWithinTimeout(Collection<FabricTransactionImpl> nonLocalTransaction) {
        long deadline = this.clock.millis() + this.awaitActiveTransactionDeadlineMillis;
        while (TransactionManager.hasOpenTransactions(nonLocalTransaction) && this.clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private static boolean hasOpenTransactions(Collection<FabricTransactionImpl> nonLocalTransaction) {
        for (FabricTransactionImpl fabricTransaction : nonLocalTransaction) {
            if (!fabricTransaction.isOpen()) continue;
            return true;
        }
        return false;
    }

    void removeTransaction(FabricTransactionImpl transaction) {
        this.openTransactions.remove(transaction);
        this.transactionMonitor.stopMonitoringTransaction(transaction);
    }

    public Set<FabricTransaction> getOpenTransactions() {
        return Collections.unmodifiableSet(this.openTransactions);
    }

    public Optional<FabricTransaction> findTransactionContaining(InternalTransaction transaction) {
        return this.openTransactions.stream().filter(tx -> tx.getInternalTransactions().stream().anyMatch(itx -> itx.kernelTransaction() == transaction.kernelTransaction())).map(FabricTransaction.class::cast).findFirst();
    }
}

