/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.values.storable.Value;

public class BridgingIndexProgressor
implements IndexProgressor.EntityValueClient,
IndexProgressor {
    private final IndexProgressor.EntityValueClient client;
    private final int[] keys;
    private final Queue<IndexProgressor> progressors = new ConcurrentLinkedQueue<IndexProgressor>();
    private final AtomicBoolean needStoreFilter = new AtomicBoolean();
    private IndexProgressor current;

    public BridgingIndexProgressor(IndexProgressor.EntityValueClient client, int[] keys) {
        this.client = client;
        this.keys = keys;
    }

    @Override
    public boolean next() {
        if (this.current == null) {
            this.current = this.progressors.poll();
        }
        while (this.current != null) {
            if (this.current.next()) {
                return true;
            }
            this.current.close();
            this.current = this.progressors.poll();
        }
        return false;
    }

    @Override
    public boolean needsValues() {
        return this.client.needsValues();
    }

    @Override
    public void close() {
        this.progressors.forEach(IndexProgressor::close);
    }

    @Override
    public void initializeQuery(IndexDescriptor descriptor, IndexProgressor progressor, boolean indexIncludesTransactionState, boolean needStoreFilter, IndexQueryConstraints constraints, PropertyIndexQuery ... queries) {
        this.assertKeysAlign(descriptor.schema().getPropertyIds());
        this.progressors.add(progressor);
        if (needStoreFilter) {
            this.needStoreFilter.set(true);
        }
    }

    private void assertKeysAlign(int[] keys) {
        if (!Arrays.equals(this.keys, keys)) {
            throw new UnsupportedOperationException("Cannot chain multiple progressors with different key set.");
        }
    }

    @Override
    public boolean acceptEntity(long reference, float score, Value ... values) {
        return this.client.acceptEntity(reference, score, values);
    }

    public boolean needStoreFilter() {
        return this.needStoreFilter.get();
    }
}

