/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.logging.InternalLog;

public class LoggingMonitor
implements IndexProvider.Monitor {
    private final InternalLog log;

    public LoggingMonitor(InternalLog log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(IndexDescriptor descriptor, String action, Exception cause) {
        if (this.log.isDebugEnabled()) {
            this.log.warn("Failed to open index:" + descriptor.getId() + ". " + action, (Throwable)cause);
        } else {
            this.log.warn("Failed to open index:" + descriptor.getId() + ". " + action + " Cause: " + cause.getMessage());
        }
    }

    @Override
    public void recoveryCleanupRegistered(Path indexFile, IndexDescriptor index) {
        this.log.info("Schema index cleanup job registered: " + LoggingMonitor.indexDescription(indexFile, index));
    }

    @Override
    public void recoveryCleanupStarted(Path indexFile, IndexDescriptor index) {
        this.log.info("Schema index cleanup job started: " + LoggingMonitor.indexDescription(indexFile, index));
    }

    @Override
    public void recoveryCleanupFinished(Path indexFile, IndexDescriptor index, long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", "Schema index cleanup job finished: " + LoggingMonitor.indexDescription(indexFile, index) + " ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of tree nodes: " + numberOfTreeNodes);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration((long)durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed(Path indexFile, IndexDescriptor index) {
        this.log.info("Schema index cleanup job closed: " + LoggingMonitor.indexDescription(indexFile, index));
    }

    @Override
    public void recoveryCleanupFailed(Path indexFile, IndexDescriptor index, Throwable throwable) {
        this.log.error(String.format("Schema index cleanup job failed: %s.%nCaused by: %s", LoggingMonitor.indexDescription(indexFile, index), ExceptionUtils.getStackTrace((Throwable)throwable)));
    }

    private static String indexDescription(Path indexFile, IndexDescriptor indexDescriptor) {
        return "descriptor=" + String.valueOf(indexDescriptor) + ", indexFile=" + String.valueOf(indexFile.toAbsolutePath());
    }
}

