/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.storageengine.api.ClosedBatchMetadata;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.OpenTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.util.ChunkedTransactionRegistry;
import org.neo4j.storageengine.util.HighestAppendBatch;
import org.neo4j.storageengine.util.HighestTransactionId;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class LogMetadataProviderImpl
implements LogMetadataProvider {
    private final AtomicLong logVersion;
    private final AtomicLong checkpointLogVersion;
    private final AtomicLong lastCommittingTx;
    private final HighestTransactionId highestCommittedTransaction;
    private final HighestTransactionId highestClosedTransaction;
    private final OutOfOrderSequence lastClosedTx;
    private final OutOfOrderSequence lastClosedBatch;
    private final AtomicLong appendIndex;
    private final HighestAppendBatch lastCommittedBatch;
    private final ChunkedTransactionRegistry chunkedTransactionRegistry = new ChunkedTransactionRegistry();
    private volatile long lowestAvailableCommittedTransactionId = 0L;
    private volatile KernelVersion kernelVersion;
    private volatile LogFormat logFormat;

    public LogMetadataProviderImpl(LogTailLogVersionsMetadata logTailMetadata, LogFormat logFormat, KernelVersion kernelVersion) {
        this.checkpointLogVersion = new AtomicLong(logTailMetadata.getCheckpointLogVersion());
        this.logVersion = new AtomicLong(logTailMetadata.getLogVersion());
        TransactionId lastCommittedTx = logTailMetadata.getLastCommittedTransaction();
        this.lastCommittingTx = new AtomicLong(lastCommittedTx.id());
        this.highestCommittedTransaction = new HighestTransactionId(lastCommittedTx);
        this.highestClosedTransaction = new HighestTransactionId(lastCommittedTx);
        LogPosition logPosition = logTailMetadata.getLastTransactionLogPosition();
        AppendBatchInfo lastBatch = logTailMetadata.lastBatch();
        this.lastCommittedBatch = new HighestAppendBatch(lastBatch);
        this.appendIndex = new AtomicLong(lastBatch.appendIndex());
        OutOfOrderSequence.Meta initialMeta = new OutOfOrderSequence.Meta(logPosition.getLogVersion(), logPosition.getByteOffset(), lastCommittedTx.kernelVersion().version(), lastCommittedTx.checksum(), lastCommittedTx.commitTimestamp(), lastCommittedTx.consensusIndex(), lastCommittedTx.appendIndex());
        this.lastClosedTx = new ArrayQueueOutOfOrderSequence(lastCommittedTx.id(), 128, initialMeta);
        this.lastClosedBatch = new ArrayQueueOutOfOrderSequence(lastBatch.appendIndex(), 128, initialMeta);
        this.logFormat = logFormat;
        this.kernelVersion = kernelVersion;
    }

    public LogMetadataProviderImpl(LogTailMetadata logTailMetadata) {
        this(logTailMetadata, logTailMetadata.getCurrentLogFormat(), logTailMetadata.kernelVersion());
    }

    @Override
    public long nextAppendIndex() {
        return this.appendIndex.incrementAndGet();
    }

    @Override
    public long getLastAppendIndex() {
        return this.appendIndex.getAcquire();
    }

    @Override
    public long getCheckpointLogVersion() {
        return this.checkpointLogVersion.get();
    }

    @Override
    public void setCheckpointLogVersion(long version) {
        this.checkpointLogVersion.set(version);
    }

    @Override
    public long incrementAndGetCheckpointLogVersion() {
        return this.checkpointLogVersion.incrementAndGet();
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long transactionAppendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion, long appendIndex) {
        this.lastCommittingTx.set(transactionId);
        OutOfOrderSequence.Meta meta = new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, transactionAppendIndex);
        this.lastClosedBatch.set(appendIndex, meta);
        this.lastClosedTx.set(transactionId, meta);
        this.highestClosedTransaction.set(transactionId, transactionAppendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
        this.highestCommittedTransaction.set(transactionId, transactionAppendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
        this.appendIndex.set(appendIndex);
        this.lastCommittedBatch.set(appendIndex, LogPosition.UNSPECIFIED);
    }

    @Override
    public long getCurrentLogVersion() {
        return this.logVersion.get();
    }

    @Override
    public void setCurrentLogVersion(long version) {
        this.logVersion.set(version);
    }

    @Override
    public long incrementAndGetVersion() {
        return this.logVersion.incrementAndGet();
    }

    @Override
    public long nextCommittingTransactionId() {
        return this.lastCommittingTx.incrementAndGet();
    }

    @Override
    public void transactionCommitted(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        this.highestCommittedTransaction.offer(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
    }

    @Override
    public long getLastCommittedTransactionId() {
        return this.highestCommittedTransaction.get().id();
    }

    @Override
    public TransactionId getLastCommittedTransaction() {
        return this.highestCommittedTransaction.get();
    }

    @Override
    public long getLastClosedTransactionId() {
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    @Override
    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.lastClosedTx.reverseSnapshot());
    }

    @Override
    public ClosedTransactionMetadata getLastClosedTransaction() {
        return new ClosedTransactionMetadata(this.lastClosedTx.get());
    }

    @Override
    public ClosedBatchMetadata getLastClosedBatch() {
        return new ClosedBatchMetadata(this.lastClosedBatch.get());
    }

    @Override
    public void transactionClosed(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.lastClosedTx.offer(transactionId, new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, appendIndex));
        this.highestClosedTransaction.offer(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
    }

    @Override
    public void batchClosed(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, KernelVersion kernelVersion, LogPosition logPositionAfter) {
        this.lastClosedBatch.offer(appendIndex, new OutOfOrderSequence.Meta(logPositionAfter.getLogVersion(), logPositionAfter.getByteOffset(), kernelVersion.version(), 1, 1L, -1L, appendIndex));
        if (lastBatch && !firstBatch) {
            this.chunkedTransactionRegistry.removeTransaction(transactionId);
        }
    }

    @Override
    public void resetLastClosedTransaction(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        OutOfOrderSequence.Meta meta = new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, appendIndex);
        this.lastClosedBatch.set(appendIndex, meta);
        this.lastClosedTx.set(transactionId, meta);
    }

    @Override
    public void appendBatch(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, LogPosition logPositionBefore, LogPosition logPositionAfter) {
        this.lastCommittedBatch.offer(appendIndex, logPositionAfter);
        if (firstBatch && lastBatch) {
            return;
        }
        if (firstBatch) {
            this.chunkedTransactionRegistry.registerTransaction(transactionId, appendIndex, logPositionBefore);
        }
    }

    @Override
    public AppendBatchInfo getLastCommittedBatch() {
        return this.lastCommittedBatch.get();
    }

    @Override
    public OpenTransactionMetadata getOldestOpenTransaction() {
        return this.chunkedTransactionRegistry.oldestOpenTransactionMetadata();
    }

    @Override
    public TransactionId getHighestEverClosedTransaction() {
        return this.highestClosedTransaction.get();
    }

    @Override
    public long getLowestAvailableCommittedTransactionId() {
        return this.lowestAvailableCommittedTransactionId;
    }

    @Override
    public void setLowestAvailableCommittedTransactionId(long transactionId) {
        this.lowestAvailableCommittedTransactionId = transactionId;
    }

    @Override
    public void setKernelVersion(KernelVersion kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    @Override
    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public void setCurrentLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    @Override
    public LogFormat getCurrentLogFormat() {
        return this.logFormat;
    }
}

