/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.storable.Value;

public final class ValueIndexEntryUpdate
extends IndexEntryUpdate {
    private final Value[] before;
    private final Value[] values;

    ValueIndexEntryUpdate(long entityId, IndexDescriptor indexKey, UpdateMode updateMode, Value[] values) {
        this(entityId, indexKey, updateMode, null, values);
    }

    ValueIndexEntryUpdate(long entityId, IndexDescriptor indexKey, UpdateMode updateMode, Value[] before, Value[] values) {
        super(entityId, indexKey, updateMode);
        ValueIndexEntryUpdate.validateValuesLength((SchemaDescriptorSupplier)indexKey, before, values);
        this.before = before;
        this.values = values;
    }

    public static ValueIndexEntryUpdate add(long entityId, IndexDescriptor indexKey, Value ... values) {
        return new ValueIndexEntryUpdate(entityId, indexKey, UpdateMode.ADDED, values);
    }

    public static ValueIndexEntryUpdate remove(long entityId, IndexDescriptor indexKey, Value ... values) {
        return new ValueIndexEntryUpdate(entityId, indexKey, UpdateMode.REMOVED, values);
    }

    public static ValueIndexEntryUpdate change(long entityId, IndexDescriptor indexKey, Value before, Value after) {
        return new ValueIndexEntryUpdate(entityId, indexKey, UpdateMode.CHANGED, new Value[]{before}, new Value[]{after});
    }

    public static ValueIndexEntryUpdate change(long entityId, IndexDescriptor indexKey, Value[] before, Value[] after) {
        return new ValueIndexEntryUpdate(entityId, indexKey, UpdateMode.CHANGED, before, after);
    }

    public Value[] values() {
        return this.values;
    }

    public Value[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }

    @Override
    public long roughSizeOfUpdate() {
        return ValueIndexEntryUpdate.heapSizeOf(this.values) + (this.updateMode() == UpdateMode.CHANGED ? ValueIndexEntryUpdate.heapSizeOf(this.before) : 0L);
    }

    @Override
    protected boolean valueEquals(IndexEntryUpdate o) {
        if (!(o instanceof ValueIndexEntryUpdate)) {
            return false;
        }
        ValueIndexEntryUpdate that = (ValueIndexEntryUpdate)o;
        if (!Arrays.equals(this.before, that.before)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    @Override
    protected int valueHash() {
        int result = Arrays.hashCode(this.before);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    protected String valueToString() {
        return String.format("beforeValues=%s, values=%s", Arrays.toString(this.before), Arrays.toString(this.values));
    }

    @Override
    public String toString() {
        return "ValueIndexEntryUpdate{entity=" + this.getEntityId() + ", before=" + Arrays.toString(this.before) + ", values=" + Arrays.toString(this.values) + ", updateMode=" + String.valueOf((Object)this.updateMode()) + ", index:" + String.valueOf(this.indexKey()) + "}";
    }

    @Override
    public IndexEntryUpdate withEntityId(long entityId) {
        return switch (this.updateMode()) {
            default -> throw new MatchException(null, null);
            case UpdateMode.ADDED -> ValueIndexEntryUpdate.add(entityId, this.indexKey(), this.values);
            case UpdateMode.CHANGED -> ValueIndexEntryUpdate.change(entityId, this.indexKey(), this.before, this.values);
            case UpdateMode.REMOVED -> ValueIndexEntryUpdate.remove(entityId, this.indexKey(), this.values);
        };
    }

    private static void validateValuesLength(SchemaDescriptorSupplier indexKey, Value[] before, Value[] values) {
        assert (indexKey.schema().getPropertyIds().length == values.length) : String.format("ValueIndexEntryUpdate values must be of same length as index compositeness. Index on %s, but got values %s", indexKey.schema().toString(), Arrays.toString(values));
        assert (before == null || before.length == values.length);
    }

    private static long heapSizeOf(Value[] values) {
        long size = 0L;
        if (values != null) {
            for (Value value : values) {
                if (value == null) continue;
                size += value.estimatedHeapUsage();
            }
        }
        return size;
    }
}

