/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging.slf4j;

import java.util.List;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jLogger;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jMarkerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class SLF4JToLog4jLoggerFactory
implements ILoggerFactory {
    private final Log4jLogProvider logProvider;
    private final SLF4JToLog4jMarkerFactory markerFactory;
    private final List<String> classPrefixes;

    public SLF4JToLog4jLoggerFactory(Log4jLogProvider logProvider, SLF4JToLog4jMarkerFactory markerFactory, List<String> classPrefixes) {
        this.logProvider = logProvider;
        this.markerFactory = markerFactory;
        this.classPrefixes = classPrefixes;
    }

    public Logger getLogger(String name) {
        if (!this.shouldInclude(name)) {
            return NOPLogger.NOP_LOGGER;
        }
        String key = SLF4JToLog4jLoggerFactory.remapRootLogger(name);
        return new SLF4JToLog4jLogger(this.markerFactory, (ExtendedLogger)this.logProvider.getLog(key), name);
    }

    private boolean shouldInclude(String name) {
        if (this.classPrefixes.isEmpty()) {
            return true;
        }
        for (String classPrefix : this.classPrefixes) {
            if (!name.startsWith(classPrefix)) continue;
            return true;
        }
        return false;
    }

    private static String remapRootLogger(String name) {
        return "ROOT".equals(name) ? "" : name;
    }
}

