/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.function.Function;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;

final class CompositeConverter
implements Function<String, DefaultParameterValue> {
    private final Neo4jTypes.AnyType upCastTo;
    private final Function<String, DefaultParameterValue>[] functions;

    @SafeVarargs
    CompositeConverter(Neo4jTypes.AnyType upCastTo, Function<String, DefaultParameterValue> ... functions) {
        this.upCastTo = upCastTo;
        this.functions = functions;
    }

    @Override
    public DefaultParameterValue apply(String s) {
        IllegalArgumentException lastException = null;
        for (Function<String, DefaultParameterValue> function : this.functions) {
            try {
                return function.apply(s).castAs(this.upCastTo);
            }
            catch (IllegalArgumentException invalidConversion) {
                lastException = (IllegalArgumentException)Exceptions.chain(lastException, (Throwable)invalidConversion);
            }
        }
        throw lastException;
    }
}

