/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.cypher.internal.expressions.functions.Category;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@Description(value="Creates a `DURATION` value.")
class DurationFunction
implements CallableUserFunction {
    private static final String CATEGORY = Category.TEMPORAL();
    private final UserFunctionSignature signature;
    private static final UserFunctionSignature DURATION_SIGNATURE_CYPHER_5 = new UserFunctionSignature(new QualifiedName("duration"), Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (String)"Either a string representation of a duration value or a map optionally containing the following keys: 'years', 'months', 'weeks', 'days', 'hours', 'minutes', 'seconds', 'milliseconds', 'microseconds', or 'nanoseconds'.")), (Neo4jTypes.AnyType)Neo4jTypes.NTDuration, false, null, DurationFunction.class.getAnnotation(Description.class).value(), CATEGORY, true, true, false, true, Set.of(QueryLanguage.CYPHER_5));
    private static final UserFunctionSignature DURATION_SIGNATURE = new UserFunctionSignature(new QualifiedName("duration"), Arrays.asList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (String)"Either a string representation of a duration value or a map optionally containing the following keys: 'years', 'months', 'weeks', 'days', 'hours', 'minutes', 'seconds', 'milliseconds', 'microseconds', or 'nanoseconds'."), FieldSignature.inputField((String)"pattern", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)TemporalFunction.DEFAULT_PATTERN_PARAMETER_VALUE, (boolean)false, (String)"A pattern used to parse a duration value. If the pattern is not provided the value will be parsed according to default patterns.")), (Neo4jTypes.AnyType)Neo4jTypes.NTDuration, false, null, DurationFunction.class.getAnnotation(Description.class).value(), CATEGORY, true, true, false, true, Set.of(QueryLanguage.CYPHER_25));

    DurationFunction(Set<QueryLanguage> supportedQueryLanguages) {
        this.signature = supportedQueryLanguages.contains(QueryLanguage.CYPHER_5) ? DURATION_SIGNATURE_CYPHER_5 : DURATION_SIGNATURE;
    }

    static void register(GlobalProcedures globalProcedures) throws ProcedureException {
        globalProcedures.register((CallableUserFunction)new DurationFunction(Set.of(QueryLanguage.CYPHER_5)));
        globalProcedures.register((CallableUserFunction)new DurationFunction(Set.of(QueryLanguage.CYPHER_25)));
        globalProcedures.register((CallableUserFunction)new Between("between"));
        globalProcedures.register((CallableUserFunction)new Between("inMonths"));
        globalProcedures.register((CallableUserFunction)new Between("inDays"));
        globalProcedures.register((CallableUserFunction)new Between("inSeconds"));
    }

    public UserFunctionSignature signature() {
        return this.signature;
    }

    public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
        if (input == null) {
            return Values.NO_VALUE;
        }
        if (input.length == 1) {
            if (input[0] == Values.NO_VALUE || input[0] == null) {
                return Values.NO_VALUE;
            }
            if (input[0] instanceof TextValue) {
                return DurationValue.parse((TextValue)((TextValue)input[0]));
            }
            AnyValue anyValue = input[0];
            if (anyValue instanceof MapValue) {
                MapValue map = (MapValue)anyValue;
                return DurationValue.build((MapValue)map);
            }
            throw ProcedureException.invalidCallSignature((String)String.valueOf(this.signature().name()), (String)this.signature().toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
        }
        if (input.length == 2) {
            if (input[0] == Values.NO_VALUE || input[0] == null || input[1] == Values.NO_VALUE || input[1] == null) {
                return Values.NO_VALUE;
            }
            AnyValue anyValue = input[0];
            if (anyValue instanceof TextValue) {
                TextValue value = (TextValue)anyValue;
                anyValue = input[1];
                if (anyValue instanceof TextValue) {
                    TextValue pattern = (TextValue)anyValue;
                    if (pattern.equals(TemporalFunction.DEFAULT_PATTERN_PARAMETER_VALUE.value())) {
                        return DurationValue.parse((TextValue)value);
                    }
                    return DurationValue.parsePattern((TextValue)value, (TextValue)pattern);
                }
            }
            if ((anyValue = input[0]) instanceof MapValue) {
                TextValue pattern;
                MapValue map = (MapValue)anyValue;
                AnyValue anyValue2 = input[1];
                if (anyValue2 instanceof TextValue && !(pattern = (TextValue)anyValue2).equals(TemporalFunction.DEFAULT_PATTERN_PARAMETER_VALUE.value())) {
                    throw ProcedureException.invalidFunctionArgument((String)this.signature.toString(), (String)"A pattern can only be used in conjunction with a `STRING` input");
                }
                return DurationValue.build((MapValue)map);
            }
            throw ProcedureException.invalidCallSignature((String)String.valueOf(this.signature().name()), (String)this.signature().toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
        }
        throw ProcedureException.invalidNumberOfProcedureOrFunctionArguments((Number)1, (Number)input.length, (String)this.getClass().getSimpleName(), (String)this.signature().toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
    }

    private static class Between
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Computes the `DURATION` between the `from` instant (inclusive) and the `to` instant (exclusive) in %s.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"from", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (String)"A temporal instant type (`DATE`, `LOCAL TIME`, `ZONED TIME`, `LOCAL DATETIME`, `ZONED DATETIME`) representing the starting instant."), FieldSignature.inputField((String)"to", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (String)"A temporal instant type (`DATE`, `LOCAL TIME`, `ZONED TIME`, `LOCAL DATETIME`, `ZONED DATETIME`) representing the ending instant."));
        private final UserFunctionSignature signature;
        private final TemporalUnit unit;

        private Between(String unit) {
            this.signature = new UserFunctionSignature(new QualifiedName("duration", unit), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDuration, false, null, String.format(DESCRIPTION, switch (unit) {
                case "between" -> {
                    this.unit = null;
                    yield "logical units";
                }
                case "inMonths" -> {
                    this.unit = ChronoUnit.MONTHS;
                    yield "months";
                }
                case "inDays" -> {
                    this.unit = ChronoUnit.DAYS;
                    yield "days";
                }
                case "inSeconds" -> {
                    this.unit = ChronoUnit.SECONDS;
                    yield "seconds";
                }
                default -> throw new IllegalStateException("Unsupported unit: " + unit);
            }), CATEGORY, true, true, false, true, QueryLanguage.ALL);
        }

        public UserFunctionSignature signature() {
            return this.signature;
        }

        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input == null || input.length == 2 && (input[0] == Values.NO_VALUE || input[0] == null) || input[1] == Values.NO_VALUE || input[1] == null) {
                return Values.NO_VALUE;
            }
            if (input.length == 2) {
                AnyValue anyValue = input[0];
                if (anyValue instanceof TemporalValue) {
                    TemporalValue from = (TemporalValue)anyValue;
                    anyValue = input[1];
                    if (anyValue instanceof TemporalValue) {
                        TemporalValue to = (TemporalValue)anyValue;
                        return DurationValue.between((TemporalUnit)this.unit, (Temporal)from, (Temporal)to);
                    }
                }
                throw ProcedureException.invalidCallSignature((String)String.valueOf(this.signature.name()), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
            }
            throw ProcedureException.invalidNumberOfProcedureOrFunctionArguments((Number)2, (Number)input.length, (String)this.getClass().getSimpleName(), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
        }
    }
}

