/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Creates a `ZONED TIME` instant.")
class TimeFunction
extends TemporalFunction<TimeValue> {
    private static final List<FieldSignature> INPUT_SIGNATURE_CYPHER_5 = Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"Either a string representation of a temporal value, a map containing the single key 'timezone', or a map containing temporal values ('hour', 'minute', 'second', 'millisecond', 'microsecond', 'nanosecond', 'timezone') as components."));
    private static final List<FieldSignature> INPUT_SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"Either a string representation of a temporal value, a map containing the single key 'timezone', or a map containing temporal values ('hour', 'minute', 'second', 'millisecond', 'microsecond', 'nanosecond', 'timezone') as components."), FieldSignature.inputField((String)"pattern", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (DefaultParameterValue)DEFAULT_PATTERN_PARAMETER_VALUE, (boolean)false, (String)"A pattern used to parse a zoned time value. If the pattern is not provided the value will be parsed according to default patterns."));

    TimeFunction(Set<QueryLanguage> supportedQueryLanguages, Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTTime, supportedQueryLanguages.contains(QueryLanguage.CYPHER_5) ? INPUT_SIGNATURE_CYPHER_5 : INPUT_SIGNATURE, supportedQueryLanguages, defaultZone);
    }

    @Override
    protected TimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? TimeValue.now((Clock)clock, defaultZone) : TimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected TimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse((TextValue)value, defaultZone);
    }

    @Override
    protected TimeValue parsePattern(TextValue value, TextValue pattern, Supplier<ZoneId> defaultZone) {
        return TimeValue.parsePattern((TextValue)value, (TextValue)pattern, defaultZone);
    }

    @Override
    protected TimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return TimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected TimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return TimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected List<FieldSignature> getTemporalTruncateSignature() {
        return Arrays.asList(FieldSignature.inputField((String)"unit", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (String)"A string representing one of the following: 'microsecond', 'millisecond', 'second', 'minute', 'hour', 'day'."), FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"The date to be truncated using either `ZONED DATETIME`, `LOCAL DATETIME`, `ZONED TIME`, or `LOCAL TIME`."), FieldSignature.inputField((String)"fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTMap), (boolean)false, (String)"A list of time components smaller than those specified in `unit` to preserve during truncation."));
    }

    @Override
    protected TimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return TimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    protected String getTemporalCypherTypeName() {
        return "ZONED TIME";
    }
}

