/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis;

import java.util.Map;
import java.util.Set;
import org.neo4j.shaded.lucene9.analysis.AbstractAnalysisFactory;
import org.neo4j.shaded.lucene9.analysis.AnalysisSPILoader;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.Tokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public abstract class TokenizerFactory
extends AbstractAnalysisFactory {
    public static TokenizerFactory forName(String name, Map<String, String> args) {
        return Holder.getLoader().newInstance(name, args);
    }

    public static Class<? extends TokenizerFactory> lookupClass(String name) {
        return Holder.getLoader().lookupClass(name);
    }

    public static Set<String> availableTokenizers() {
        return Holder.getLoader().availableServices();
    }

    public static String findSPIName(Class<? extends TokenizerFactory> serviceClass) {
        try {
            return AnalysisSPILoader.lookupSPIName(serviceClass);
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void reloadTokenizers(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    protected TokenizerFactory() {
    }

    protected TokenizerFactory(Map<String, String> args) {
        super(args);
    }

    public final Tokenizer create() {
        return this.create(TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
    }

    public abstract Tokenizer create(AttributeFactory var1);

    private static final class Holder {
        private static final AnalysisSPILoader<TokenizerFactory> LOADER = new AnalysisSPILoader<TokenizerFactory>(TokenizerFactory.class);

        private Holder() {
        }

        static AnalysisSPILoader<TokenizerFactory> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a TokenizerFactory by name before all factories could be initialized. This likely happens if you call TokenizerFactory#forName from a TokenizerFactory ctor.");
            }
            return LOADER;
        }
    }
}

