/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.shaded.lucene9.analysis.CharArrayMap;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.util.IOUtils;

public class WordlistLoader {
    private static final int INITIAL_CAPACITY = 16;

    private WordlistLoader() {
    }

    public static CharArraySet getWordSet(Reader reader, CharArraySet result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String word = null;
            while ((word = br.readLine()) != null) {
                if ((word = word.trim()).isEmpty()) continue;
                result.add(word);
            }
        }
        return result;
    }

    public static CharArraySet getWordSet(Reader reader) throws IOException {
        return CharArraySet.unmodifiableSet(WordlistLoader.getWordSet(reader, new CharArraySet(16, false)));
    }

    public static CharArraySet getWordSet(InputStream stream) throws IOException {
        return WordlistLoader.getWordSet(stream, StandardCharsets.UTF_8);
    }

    public static CharArraySet getWordSet(InputStream stream, Charset charset) throws IOException {
        return WordlistLoader.getWordSet(IOUtils.getDecodingReader(stream, charset));
    }

    public static CharArraySet getWordSet(Reader reader, String comment, CharArraySet result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String word = null;
            while ((word = br.readLine()) != null) {
                if (word.startsWith(comment) || (word = word.trim()).isEmpty()) continue;
                result.add(word);
            }
        }
        return result;
    }

    public static CharArraySet getWordSet(Reader reader, String comment) throws IOException {
        return CharArraySet.unmodifiableSet(WordlistLoader.getWordSet(reader, comment, new CharArraySet(16, false)));
    }

    public static CharArraySet getWordSet(InputStream stream, String comment) throws IOException {
        return WordlistLoader.getWordSet(stream, StandardCharsets.UTF_8, comment);
    }

    public static CharArraySet getWordSet(InputStream stream, Charset charset, String comment) throws IOException {
        return WordlistLoader.getWordSet(IOUtils.getDecodingReader(stream, charset), comment);
    }

    public static CharArraySet getSnowballWordSet(Reader reader, CharArraySet result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String line = null;
            while ((line = br.readLine()) != null) {
                int comment = line.indexOf(124);
                if (comment >= 0) {
                    line = line.substring(0, comment);
                }
                String[] words = line.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    if (words[i].length() <= 0) continue;
                    result.add(words[i]);
                }
            }
        }
        return result;
    }

    public static CharArraySet getSnowballWordSet(Reader reader) throws IOException {
        return CharArraySet.unmodifiableSet(WordlistLoader.getSnowballWordSet(reader, new CharArraySet(16, false)));
    }

    public static CharArraySet getSnowballWordSet(InputStream stream) throws IOException {
        return WordlistLoader.getSnowballWordSet(stream, StandardCharsets.UTF_8);
    }

    public static CharArraySet getSnowballWordSet(InputStream stream, Charset charset) throws IOException {
        return WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(stream, charset));
    }

    public static CharArrayMap<String> getStemDict(Reader reader, CharArrayMap<String> result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] wordstem = line.split("\t", 2);
                result.put(wordstem[0], wordstem[1]);
            }
        }
        return result;
    }

    public static List<String> getLines(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader input = WordlistLoader.getBufferedReader(IOUtils.getDecodingReader(stream, charset));){
            ArrayList<String> lines = new ArrayList<String>();
            String word = null;
            while ((word = input.readLine()) != null) {
                if (lines.isEmpty() && word.length() > 0 && word.charAt(0) == '\ufeff') {
                    word = word.substring(1);
                }
                if (word.startsWith("#") || (word = word.trim()).length() == 0) continue;
                lines.add(word);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    private static BufferedReader getBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

