/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.compound;

import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.compound.CompoundWordTokenFilterBase;

public class DictionaryCompoundWordTokenFilter
extends CompoundWordTokenFilterBase {
    public DictionaryCompoundWordTokenFilter(TokenStream input, CharArraySet dictionary) {
        super(input, dictionary);
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary must not be null");
        }
    }

    public DictionaryCompoundWordTokenFilter(TokenStream input, CharArraySet dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary must not be null");
        }
    }

    @Override
    protected void decompose() {
        int len = this.termAtt.length();
        for (int i = 0; i <= len - this.minSubwordSize; ++i) {
            CompoundWordTokenFilterBase.CompoundToken longestMatchToken = null;
            for (int j = this.minSubwordSize; j <= this.maxSubwordSize && i + j <= len; ++j) {
                if (!this.dictionary.contains(this.termAtt.buffer(), i, j)) continue;
                if (this.onlyLongestMatch) {
                    if (longestMatchToken != null) {
                        if (longestMatchToken.txt.length() >= j) continue;
                        longestMatchToken = new CompoundWordTokenFilterBase.CompoundToken(i, j);
                        continue;
                    }
                    longestMatchToken = new CompoundWordTokenFilterBase.CompoundToken(i, j);
                    continue;
                }
                this.tokens.add(new CompoundWordTokenFilterBase.CompoundToken(i, j));
            }
            if (!this.onlyLongestMatch || longestMatchToken == null) continue;
            this.tokens.add(longestMatchToken);
        }
    }
}

