/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.de;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.shaded.lucene9.analysis.Analyzer;
import org.neo4j.shaded.lucene9.analysis.CharArraySet;
import org.neo4j.shaded.lucene9.analysis.LowerCaseFilter;
import org.neo4j.shaded.lucene9.analysis.StopFilter;
import org.neo4j.shaded.lucene9.analysis.StopwordAnalyzerBase;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.WordlistLoader;
import org.neo4j.shaded.lucene9.analysis.de.GermanLightStemFilter;
import org.neo4j.shaded.lucene9.analysis.de.GermanNormalizationFilter;
import org.neo4j.shaded.lucene9.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.neo4j.shaded.lucene9.analysis.snowball.SnowballFilter;
import org.neo4j.shaded.lucene9.analysis.standard.StandardTokenizer;
import org.neo4j.shaded.lucene9.util.IOUtils;

public final class GermanAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "german_stop.txt";
    private final CharArraySet exclusionSet;

    public static final CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GermanAnalyzer() {
        this(DefaultSetHolder.DEFAULT_SET);
    }

    public GermanAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public GermanAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.exclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        result = new SetKeywordMarkerFilter(result, this.exclusionSet);
        result = new GermanNormalizationFilter(result);
        result = new GermanLightStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new GermanNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        private static final CharArraySet DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = WordlistLoader.getSnowballWordSet(IOUtils.requireResourceNonNull(SnowballFilter.class.getResourceAsStream(GermanAnalyzer.DEFAULT_STOPWORD_FILE), GermanAnalyzer.DEFAULT_STOPWORD_FILE));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

