/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.email;

import java.util.Map;
import org.neo4j.shaded.lucene9.analysis.TokenizerFactory;
import org.neo4j.shaded.lucene9.analysis.email.UAX29URLEmailTokenizer;
import org.neo4j.shaded.lucene9.util.AttributeFactory;

public class UAX29URLEmailTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "uax29UrlEmail";
    private final int maxTokenLength;

    public UAX29URLEmailTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxTokenLength = this.getInt(args, "maxTokenLength", 255);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public UAX29URLEmailTokenizerFactory() {
        throw UAX29URLEmailTokenizerFactory.defaultCtorException();
    }

    @Override
    public UAX29URLEmailTokenizer create(AttributeFactory factory) {
        UAX29URLEmailTokenizer tokenizer = new UAX29URLEmailTokenizer(factory);
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

