/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.en;

import java.io.IOException;
import org.neo4j.shaded.lucene9.analysis.TokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;

public final class EnglishPossessiveFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public EnglishPossessiveFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        if (!(bufferLength < 2 || buffer[bufferLength - 2] != '\'' && buffer[bufferLength - 2] != '\u2019' && buffer[bufferLength - 2] != '\uff07' || buffer[bufferLength - 1] != 's' && buffer[bufferLength - 1] != 'S')) {
            this.termAtt.setLength(bufferLength - 2);
        }
        return true;
    }
}

