/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.fa;

import java.util.Arrays;
import org.neo4j.shaded.lucene9.analysis.util.StemmerUtil;

public class PersianStemmer {
    private static final char ALEF = '\u0627';
    private static final char HEH = '\u0647';
    private static final char TEH = '\u062a';
    private static final char REH = '\u0631';
    private static final char NOON = '\u0646';
    private static final char YEH = '\u064a';
    private static final char ZWNJ = '\u200c';
    private static final char[][] suffixes = new char[][]{"\u0627\u062a".toCharArray(), "\u0627\u0646".toCharArray(), "\u062a\u0631\u064a\u0646".toCharArray(), "\u062a\u0631".toCharArray(), "\u064a\u064a".toCharArray(), "\u064a".toCharArray(), "\u0647\u0627".toCharArray(), "\u200c".toCharArray()};

    public int stem(char[] s, int len) {
        len = this.stemSuffix(s, len);
        return len;
    }

    private int stemSuffix(char[] s, int len) {
        for (char[] suffix : suffixes) {
            if (!this.endsWithCheckLength(s, len, suffix)) continue;
            len = StemmerUtil.deleteN(s, len - suffix.length, len, suffix.length);
        }
        return len;
    }

    private boolean endsWithCheckLength(char[] s, int len, char[] suffix) {
        if (len < suffix.length + 2) {
            return false;
        }
        return Arrays.equals(s, len - suffix.length, len, suffix, 0, suffix.length);
    }
}

