/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.analysis.miscellaneous;

import org.neo4j.shaded.lucene9.analysis.FilteringTokenFilter;
import org.neo4j.shaded.lucene9.analysis.TokenStream;
import org.neo4j.shaded.lucene9.analysis.tokenattributes.CharTermAttribute;

public final class CodepointCountFilter
extends FilteringTokenFilter {
    private final int min;
    private final int max;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public CodepointCountFilter(TokenStream in, int min, int max) {
        super(in);
        if (min < 0) {
            throw new IllegalArgumentException("minimum length must be greater than or equal to zero");
        }
        if (min > max) {
            throw new IllegalArgumentException("maximum length must not be greater than minimum length");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean accept() {
        int max32 = this.termAtt.length();
        int min32 = max32 >> 1;
        if (min32 >= this.min && max32 <= this.max) {
            return true;
        }
        if (min32 > this.max || max32 < this.min) {
            return false;
        }
        int len = Character.codePointCount(this.termAtt.buffer(), 0, this.termAtt.length());
        return len >= this.min && len <= this.max;
    }
}

